/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class Tester {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_USER = 0;
    private static final int CMD_PASSWORD = 1;
    private static final int CMD_DATABASE = 2;
    private static final int CMD_HOSTNAME = 3;
    private static final int CMD_PORT = 4;
    private static final int CMD_DEBUG = 5;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    private static final int getCommand(String string) {
        int n = s_commands.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!((String)s_commands.get(i)).startsWith(string)) continue;
            if (n2 != -1) {
                return -2;
            }
            n2 = i;
        }
        return n2;
    }

    public static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("usage: java org.postgresql.pljava.test.Tester");
        printStream.println("    [ -host <hostName>     ]    # default is localhost");
        printStream.println("    [ -port <portNubmer>   ]    # default is blank");
        printStream.println("    [ -database <database> ]    # default is name of current user");
        printStream.println("    [ -user <userName>     ]    # default is name of current user");
        printStream.println("    [ -password <password> ]    # default is no password");
        printStream.println("    [ -debug ]    # wait for debugger to attach to backend");
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        String string2 = "org.postgresql.Driver";
        String string3 = "localhost";
        String string4 = null;
        String string5 = string = System.getProperty("user.name", "postgres");
        String string6 = "postgresql";
        String string7 = null;
        boolean bl = false;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            if (((String)object).length() < 2) {
                Tester.printUsage();
                return;
            }
            if (((String)object).charAt(0) != '-') continue;
            int n2 = Tester.getCommand(((String)object).substring(1));
            switch (n2) {
                case 5: {
                    bl = true;
                    continue block10;
                }
                case 0: {
                    if (++i < n && (string = stringArray[i]).length() > 0 && string.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 1: {
                    if (++i < n && (string7 = stringArray[i]).length() > 0 && string7.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 2: {
                    if (++i < n && (string5 = stringArray[i]).length() > 0 && string5.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 3: {
                    if (++i < n && (string3 = stringArray[i]).length() > 0 && string3.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                case 4: {
                    if (++i < n && (string4 = stringArray[i]).length() > 0 && string4.charAt(0) != '-') continue block10;
                    Tester.printUsage();
                    return;
                }
                default: {
                    Tester.printUsage();
                    return;
                }
            }
        }
        try {
            Class.forName(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jdbc:");
            stringBuffer.append(string6);
            stringBuffer.append("://");
            stringBuffer.append(string3);
            if (string4 != null) {
                stringBuffer.append(':');
                stringBuffer.append(string4);
            }
            stringBuffer.append('/');
            stringBuffer.append(string5);
            object = DriverManager.getConnection(stringBuffer.toString(), string, string7);
            Tester tester = new Tester((Connection)object);
            if (bl) {
                System.out.println("Attach debugger to backend");
                Thread.sleep(30000L);
                System.out.println("continuing");
            }
            for (int i = 0; i < 10; ++i) {
                tester.testParameters();
                tester.testInsertUsernameTrigger();
                tester.testModdatetimeTrigger();
                tester.testSPIActions();
                tester.testComplexReturn();
                tester.testSetReturn();
                tester.testCallInCall();
                tester.testCurrentDir();
                tester.testUsingProperties();
                tester.testUsingScalarProperties();
                tester.testUsingResultSetProperties();
                tester.testSavepointSanity();
                tester.testTrustedSecurity();
                tester.testDatabaseMetaData();
            }
            tester.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Tester(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("SET search_path TO javatest,public");
        statement.close();
        this.m_connection = connection;
    }

    public void close() throws SQLException {
        this.m_connection.close();
    }

    public void testParameters() throws SQLException {
        this.testTimestamp();
        this.testInt();
    }

    public void testSPIActions() throws SQLException {
        System.out.println("*** testSPIActions()");
        Statement statement = this.m_connection.createStatement();
        statement.execute("DELETE FROM employees1");
        statement.execute("DELETE FROM employees2");
        statement.execute("INSERT INTO employees1 VALUES(1, 'Calvin Forrester', 10000)");
        statement.execute("INSERT INTO employees1 VALUES(2, 'Edwin Archer', 20000)");
        statement.execute("INSERT INTO employees1 VALUES(3, 'Rebecka Shawn', 30000)");
        statement.execute("INSERT INTO employees1 VALUES(4, 'Priscilla Johnson', 25000)");
        statement.execute("SELECT transferPeople(20000)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM employees2");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            String string = resultSet.getString(2);
            int n2 = resultSet.getInt(3);
            System.out.println("Id = \"" + n + "\", name = \"" + string + "\", salary = \"" + n2 + "\"");
        }
        resultSet.close();
    }

    public void testComplexReturn() throws SQLException {
        System.out.println("*** testComplexReturn()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT complexReturnToString(complexReturnExample(1, 5))");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            System.out.println(string);
        }
        resultSet.close();
    }

    public void testSetReturn() throws SQLException {
        System.out.println("*** testSetReturn()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT base, incbase, ctime FROM setReturnExample(1, 5)");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = resultSet.getInt(2);
            Timestamp timestamp = resultSet.getTimestamp(3);
            System.out.println("Base = \"" + n + "\", incbase = \"" + n2 + "\", ctime = \"" + timestamp + "\"");
        }
        resultSet.close();
    }

    public void testUsingProperties() throws SQLException {
        System.out.println("*** testUsingProperties()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT name, value FROM propertyExample()");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            System.out.println("Name = \"" + string + "\", value = \"" + string2 + "\"");
        }
        resultSet.close();
    }

    public void testUsingResultSetProperties() throws SQLException {
        System.out.println("*** testUsingResultSetProperties()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT name, value FROM resultSetPropertyExample()");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            System.out.println("Name = \"" + string + "\", value = \"" + string2 + "\"");
        }
        resultSet.close();
    }

    public void testUsingScalarProperties() throws SQLException {
        System.out.println("*** testUsingScalarProperties()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT scalarPropertyExample()");
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1));
        }
        resultSet.close();
    }

    public void testCallInCall() throws SQLException {
        System.out.println("*** testCallInCall()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT maxFromSetReturnExample(10, 8)");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            System.out.println("Max = \"" + n + "\"");
        }
    }

    public void testModdatetimeTrigger() throws SQLException {
        Timestamp timestamp;
        String string;
        int n;
        System.out.println("*** testModdatetimeTrigger()");
        Statement statement = this.m_connection.createStatement();
        statement.execute("DELETE FROM mdt");
        statement.execute("INSERT INTO mdt VALUES (1, 'first')");
        statement.execute("INSERT INTO mdt VALUES (2, 'second')");
        statement.execute("INSERT INTO mdt VALUES (3, 'third')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM mdt");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            string = resultSet.getString(2);
            timestamp = resultSet.getTimestamp(3);
            System.out.println("Id = \"" + n + "\", idesc = \"" + string + "\", moddate = \"" + timestamp + "\"");
        }
        resultSet.close();
        statement.execute("UPDATE mdt SET id = 4 WHERE id = 1");
        statement.execute("UPDATE mdt SET id = 5 WHERE id = 2");
        statement.execute("UPDATE mdt SET id = 6 WHERE id = 3");
        resultSet = statement.executeQuery("SELECT * FROM mdt");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            string = resultSet.getString(2);
            timestamp = resultSet.getTimestamp(3);
            System.out.println("Id = \"" + n + "\", idesc = \"" + string + "\", moddate = \"" + timestamp + "\"");
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertUsernameTrigger() throws SQLException {
        System.out.println("*** testInsertUsernameTrigger()");
        Statement statement = this.m_connection.createStatement();
        statement.execute("DELETE FROM username_test");
        statement.execute("INSERT INTO username_test VALUES ('nothing', 'thomas')");
        statement.execute("INSERT INTO username_test VALUES ('null', null)");
        statement.execute("INSERT INTO username_test VALUES ('empty string', '')");
        statement.execute("INSERT INTO username_test VALUES ('space', ' ')");
        statement.execute("INSERT INTO username_test VALUES ('tab', '\t')");
        statement.execute("INSERT INTO username_test VALUES ('name', 'name')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM username_test");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            System.out.println("Name = \"" + string + "\", username = \"" + string2 + "\"");
        }
        resultSet.close();
        statement.close();
    }

    public void testTimestamp() throws SQLException {
        System.out.println("*** testTimestamp()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_getTimestamp(), java_getTimestamptz()");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Timestamp = " + resultSet.getTimestamp(1) + ", Timestamptz = " + resultSet.getTimestamp(2));
        }
        resultSet.close();
        statement.execute("SELECT java_print(current_date)");
        statement.execute("SELECT java_print(current_time)");
        statement.execute("SELECT java_print(current_timestamp)");
        statement.close();
    }

    public void testInt() throws SQLException {
        System.out.println("*** testInt()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_addOne(java_addOne(54)), nullOnEven(1), nullOnEven(2)");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("54 + 2 = " + resultSet.getInt(1));
            int n = resultSet.getInt(2);
            System.out.println("nullOnEven(1) = " + (resultSet.wasNull() ? "null" : Integer.toString(n)));
            n = resultSet.getInt(3);
            System.out.println("nullOnEven(2) = " + (resultSet.wasNull() ? "null" : Integer.toString(n)));
        }
        resultSet.close();
        statement.close();
    }

    public void testCurrentDir() throws SQLException {
        System.out.println("*** testCurrentDir()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT java_getSystemProperty('user.dir')");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Server directory = " + resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testSavepointSanity() throws SQLException {
        System.out.println("*** testSavepointSanity()");
        Statement statement = this.m_connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT testSavepointSanity()");
        if (!resultSet.next()) {
            System.out.println("Unable to position ResultSet");
        } else {
            System.out.println("Savepoint sanity = " + resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTrustedSecurity() throws SQLException {
        block16: {
            block17: {
                block13: {
                    block11: {
                        block15: {
                            block12: {
                                System.out.println("*** testTrustedSecurity()");
                                var1_1 = this.m_connection.createStatement();
                                var2_2 = null;
                                this.tryCreateTempFile(true);
                                var3_3 = false;
                                try {
                                    var2_2 = var1_1.executeQuery("SHOW IS_SUPERUSER");
                                    if (!var2_2.next() || !var2_2.getString(1).equals("on")) {
                                        System.out.println("Tester is not superuser so tests on untrusted language cannot be performed");
                                        var5_4 = null;
                                        if (var2_2 == null) break block11;
                                        break block12;
                                    }
                                    System.out.println("*** testUntrustedSecurity()");
                                    var1_1.execute("CREATE OR REPLACE FUNCTION javatest.create_temp_file_untrusted()  RETURNS varchar  AS 'org.postgresql.pljava.example.Security.createTempFile'  LANGUAGE javaU");
                                    this.tryCreateTempFile(false);
                                    break block13;
                                }
                                catch (Throwable var4_10) {
                                    var5_6 = null;
                                    if (var2_2 != null) {
                                        try {
                                            var2_2.close();
                                        }
                                        catch (SQLException var6_9) {
                                            // empty catch block
                                        }
                                        var2_2 = null;
                                    }
                                    if (var3_3) {
                                        var1_1.execute("DROP FUNCTION javatest.create_temp_file_untrusted()");
                                    }
                                    var1_1.close();
                                    throw var4_10;
                                }
                            }
                            ** try [egrp 1[TRYBLOCK] [3 : 114->123)] { 
lbl38:
                            // 1 sources

                            var2_2.close();
                            break block15;
lbl40:
                            // 1 sources

                            catch (SQLException var6_7) {
                                // empty catch block
                            }
                        }
                        var2_2 = null;
                    }
                    if (var3_3) {
                        var1_1.execute("DROP FUNCTION javatest.create_temp_file_untrusted()");
                    }
                    var1_1.close();
                    return;
                }
                var5_5 = null;
                if (var2_2 == null) break block16;
                ** try [egrp 1[TRYBLOCK] [3 : 114->123)] { 
lbl54:
                // 1 sources

                var2_2.close();
                break block17;
lbl56:
                // 1 sources

                catch (SQLException var6_8) {
                    // empty catch block
                }
            }
            var2_2 = null;
        }
        if (var3_3) {
            var1_1.execute("DROP FUNCTION javatest.create_temp_file_untrusted()");
        }
        var1_1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void tryCreateTempFile(boolean bl) throws SQLException {
        block16: {
            ResultSet resultSet;
            Statement statement;
            block14: {
                statement = this.m_connection.createStatement();
                resultSet = null;
                resultSet = bl ? statement.executeQuery("SELECT create_temp_file_trusted()") : statement.executeQuery("SELECT create_temp_file_untrusted()");
                if (!resultSet.next()) {
                    System.out.println("Unable to position ResultSet");
                } else {
                    System.out.println("Name of created temp file = " + resultSet.getString(1));
                }
                if (bl) {
                    throw new RuntimeException("ERROR: Tempfile creation succeded although language is trusted!");
                }
                Object var6_4 = null;
                if (resultSet == null) break block14;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                resultSet = null;
            }
            statement.close();
            {
                break block16;
                catch (SQLException sQLException) {
                    if (!bl) {
                        throw sQLException;
                    }
                    System.out.println("OK, creation of temp file was *unsuccessful* as it should be");
                    Object var6_5 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                        resultSet = null;
                    }
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                statement.close();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDatabaseMetaData() throws SQLException {
        block9: {
            Statement statement = this.m_connection.createStatement();
            ResultSet resultSet = null;
            try {
                String string;
                System.out.println("*** DatabaseMetaData 'String' functions:");
                resultSet = statement.executeQuery("SELECT * FROM javatest.getMetaDataStrings()");
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    System.out.println("Method = \"" + string + "\", result = \"" + string2 + "\"");
                }
                resultSet.close();
                System.out.println("*** DatabaseMetaData 'boolean' functions:");
                resultSet = statement.executeQuery("SELECT * FROM javatest.getMetaDataBooleans()");
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    boolean bl = resultSet.getBoolean(2);
                    System.out.println("Method = \"" + string + "\", result = \"" + bl + "\"");
                }
                resultSet.close();
                System.out.println("*** DatabaseMetaData 'int' functions:");
                resultSet = statement.executeQuery("SELECT * FROM javatest.getMetaDataInts()");
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    System.out.println("Method = \"" + string + "\", result = \"" + n + "\"");
                }
                resultSet.close();
                this.executeMetaDataFunction(statement, "getAttributes((String)null,\"javatest\",\"%\",\"%\")");
                this.executeMetaDataFunction(statement, "getBestRowIdentifier((String)null,\"sqlj\",\"jar_repository\",0,FALSE)");
                this.executeMetaDataFunction(statement, "getCatalogs()");
                this.executeMetaDataFunction(statement, "getColumnPrivileges((String)null,\"sqlj\",\"jar_repository\",\"jarid\")");
                this.executeMetaDataFunction(statement, "getColumns((String)null,\"sqlj\",\"jar_repository\",\"%\")");
                this.executeMetaDataFunction(statement, "getCrossReference((String)null,\"sqlj\",\"jar_repository\",(String)null,\"sqlj\",\"jar_entry\")");
                this.executeMetaDataFunction(statement, "getExportedKeys((String)null,\"sqlj\",\"jar_repository\")");
                this.executeMetaDataFunction(statement, "getImportedKeys((String)null,\"sqlj\",\"jar_repository\")");
                this.executeMetaDataFunction(statement, "getIndexInfo((String)null,\"sqlj\",\"jar_repository\",TRUE,FALSE)");
                this.executeMetaDataFunction(statement, "getPrimaryKeys((String)null,\"sqlj\",\"jar_repository\")");
                this.executeMetaDataFunction(statement, "getProcedureColumns((String)null,\"sqlj\",\"install_jar\",(String)null)");
                this.executeMetaDataFunction(statement, "getProcedures((String)null,\"sqlj\",\"%\")");
                this.executeMetaDataFunction(statement, "getSchemas()");
                this.executeMetaDataFunction(statement, "getSuperTables((String)null,\"sqlj\",\"jar_repository\")");
                this.executeMetaDataFunction(statement, "getSuperTypes((String)null,\"sqlj\",\"%\")");
                this.executeMetaDataFunction(statement, "getTablePrivileges((String)null,\"sqlj\",\"jar_repository\")");
                this.executeMetaDataFunction(statement, "getTables((String)null,\"sqlj\",\"jar%\",{\"TABLE\"})");
                this.executeMetaDataFunction(statement, "getTableTypes()");
                this.executeMetaDataFunction(statement, "getTypeInfo()");
                this.executeMetaDataFunction(statement, "getUDTs((String)null,\"sqlj\",\"%\",(int[])null)");
                this.executeMetaDataFunction(statement, "getVersionColumns((String)null,\"sqlj\",\"jar_repository\")");
                Object var6_7 = null;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            resultSet = null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void executeMetaDataFunction(Statement statement, String string) throws SQLException {
        block10: {
            ResultSet resultSet = null;
            System.out.println("*** " + string + ":");
            resultSet = statement.executeQuery("SELECT * FROM javatest.callMetaDataMethod('" + string + "')");
            while (resultSet.next()) {
                System.out.println(resultSet.getString(1));
            }
            resultSet.close();
            Object var6_4 = null;
            if (resultSet == null) break block10;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            resultSet = null;
            {
                break block10;
                catch (Exception exception) {
                    System.out.println("  Failed: " + exception.getMessage());
                    Object var6_5 = null;
                    if (resultSet == null) break block10;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                throw throwable;
            }
        }
    }

    static {
        s_commands.add(0, "user");
        s_commands.add(1, "password");
        s_commands.add(2, "database");
        s_commands.add(3, "host");
        s_commands.add(4, "port");
        s_commands.add(5, "debug");
    }
}

