/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.HeapTupleHeader;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SingleTupleReader
extends SingleRowResultSet {
    private TupleDesc m_tupleDesc;
    private final HeapTupleHeader m_tupleHeader;

    public SingleTupleReader(HeapTupleHeader heapTupleHeader) throws SQLException {
        this.m_tupleHeader = heapTupleHeader;
    }

    protected Object getObjectValue(int n) throws SQLException {
        return this.m_tupleHeader.getObject(n);
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public void cancelRowUpdates() throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    public void deleteRow() throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    public void insertRow() throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    public void moveToInsertRow() throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    public void updateRow() throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw SingleTupleReader.readOnlyException();
    }

    private static SQLException readOnlyException() {
        return new UnsupportedFeatureException("ResultSet is read-only");
    }

    protected final TupleDesc getTupleDesc() throws SQLException {
        if (this.m_tupleDesc == null) {
            this.m_tupleDesc = this.m_tupleHeader.getTupleDesc();
        }
        return this.m_tupleDesc;
    }
}

