/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Environment {
    private static final Pattern s_envPattern = Pattern.compile("^(\\w+)=(.*)$");
    private static final Pattern s_osPattern = Pattern.compile("^windows\\W", 2);
    private static final boolean s_isWindows;
    private final TreeMap m_env;

    private static String getEnvCommand() {
        return s_isWindows ? "cmd /C set" : "sh -c env";
    }

    public static boolean isWindows() {
        return s_isWindows;
    }

    public Environment() throws IOException {
        String string;
        TreeMap<String, Object> treeMap;
        this.m_env = treeMap = new TreeMap<String, Object>();
        Process process = Runtime.getRuntime().exec(Environment.getEnvCommand());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = s_envPattern.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (s_isWindows) {
                treeMap.put(string2.toLowerCase(), new String[]{string2, string3});
                continue;
            }
            treeMap.put(string2, string3);
        }
    }

    public String get(String string) {
        if (s_isWindows) {
            String[] stringArray = (String[])this.m_env.get(string.toLowerCase());
            return stringArray == null ? null : stringArray[1];
        }
        return (String)this.m_env.get(string);
    }

    public void put(String string, String string2) {
        if (s_isWindows) {
            String string3 = string.toLowerCase();
            String[] stringArray = (String[])this.m_env.get(string3);
            if (stringArray == null) {
                this.m_env.put(string3, new String[]{string, string2});
            } else {
                stringArray[1] = string2;
            }
        } else {
            this.m_env.put(string, string2);
        }
    }

    public String[] asArray() {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.m_env.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (s_isWindows) {
                String[] stringArray = (String[])entry.getValue();
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('=');
                stringBuffer.append(stringArray[1]);
            } else {
                stringBuffer.append(entry.getKey());
                stringBuffer.append('=');
                stringBuffer.append(entry.getValue());
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        Iterator iterator = this.m_env.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (s_isWindows) {
                String[] stringArray = (String[])entry.getValue();
                stringBuffer.append(stringArray[0]);
                stringBuffer.append(" = ");
                stringBuffer.append(stringArray[1]);
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(entry.getKey());
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static {
        Pattern pattern = Pattern.compile("^windows\\W", 2);
        s_isWindows = pattern.matcher(System.getProperty("os.name")).lookingAt();
    }
}

