<?php

if (!isset($message)) {
	include("header.inc.php");
} else {
	show_message($message);
}

$sql_func_props = "
	SELECT 
		proname, 
		lanname as language,
		pt.typname as return_type,
		pa.typname as argtype,
		prosrc as source
	FROM 
		pg_proc pc, pg_language pl, pg_type pt, pg_type pa
	WHERE 
		proname = '$function'
		AND pc.prolang = pl.oid
		AND pc.prorettype = pt.oid
	";

$sql_func_args = "
	SELECT 
		proname, 
		pa.typname as argtype
	FROM 
		pg_proc pc, pg_type pa
	WHERE 
		proname = '$function'
		AND
		(
			pa.oid = pc.proargtypes[0]
			OR pa.oid = pc.proargtypes[1]
			OR pa.oid = pc.proargtypes[2]
			OR pa.oid = pc.proargtypes[3]
			OR pa.oid = pc.proargtypes[4]
			OR pa.oid = pc.proargtypes[5]
			OR pa.oid = pc.proargtypes[6]
			OR pa.oid = pc.proargtypes[7]
		)
	";

if (!$res_props = pg_exec($link, $sql_func_props)) {
	pg_die();
} else {
	$row = @pg_fetch_array($res_props, 0);

	if (!$res_args = pg_exec($link, $sql_func_args)) {
		pg_die();
	} else {
		$num_rows = pg_numrows($res_args);
		for ($i_numrows = 0; $i_numrows < $num_rows; $i_numrows++) {
			$arg_row = pg_fetch_array($res_args, $i_numrows);
			$strArgList .= " $arg_row[argtype], ";
		}
	}

	?>
	<table border=<?php echo $cfgBorder;?>>
	<TR>
	<TH><?php echo $strFunc; ?></TH>
	<TH><?php echo $strRetType; ?></TH>
	<TH><?php echo $strLang; ?></TH>
	<TH><?php echo $strArgs; ?></TH>
	</TR>

	<tr bgcolor="<?php echo $cfgBgcolorOne;?>">
	<td class=data><b><?php echo $row[proname];?></b></td>
	<td><?php echo $row[return_type]; ?></td>
	<td><?php echo $row[language]; ?></td>
	<?php
	$strArgList = ereg_replace(", $", "", $strArgList); //"
	echo "<td>$strArgList&nbsp</td>";
	?>
	<tr><th colspan=4><?php echo $strSrc;?></th></tr>
	<tr>
		<td colspan=4 bgcolor="<?php echo $cfgBgcolorTwo; ?>"><?php echo nl2br($row[source]); ?></td>
	</tr>
	<?php
	echo "</table>";
}

include ("footer.inc.php");
?>
