/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: mmsystem.c */
#include "mmsystem.h"
#include "common.h"

struct dmem_list* dmlist= NULL;
struct mem_list*  mlist = NULL;				/* ALWAYS INITIALIZE WITH NULL, OR WILL BE TROUBLE !!!! */

void add_to_special_memlist(struct mem_list** head, void* ptr)
{
 struct mem_list* newh;
 sdebug("%s:%d add_to_special_memlist",__FILE__,__LINE__);
 if (!(*head))
   {
    *head = (struct mem_list*)malloc(sizeof(struct mem_list));
    if (!(*head)) { fatal("smalloc failed!"); return; }
    (*head)->ptr  = ptr;
    (*head)->next = NULL;
    return;
   }
 newh = (struct mem_list*)malloc(sizeof(struct mem_list));
 if (!newh) { fatal("smalloc failed!"); return; }
 newh->ptr   = ptr;
 newh->next  = *head;
 *head       = newh; 
}


void print_special_memlist(struct mem_list* head)
{
#ifdef NO_TRACE_MEM
 return;
#else
 struct mem_list* tmp;
 sdebug("%s:%d print_special_memlist",__FILE__,__LINE__);
 tmp = head;
 printf("MEMLIST_SPECIAL:\n");
 while (tmp)
   {
    printf("%p\n", tmp->ptr);
    tmp = tmp->next;
   }
 printf("MEMLIST_SPECIAL END\n");
#endif
}

void del_from_special_memlist(struct mem_list** head, void* ptr)
{
 struct mem_list *tmp, *prev;
 sdebug("%s:%d del_from_special_memlist",__FILE__,__LINE__);
 tmp = prev = *head;
 while (tmp)
   {
    if (tmp->ptr==ptr)
      {
       if (tmp==(*head))
         {
          *head = tmp->next;
	  free(tmp);
	  tmp = NULL;
	  return ;
         }
       prev->next = tmp->next;
       free(tmp);
       tmp = NULL;
       return ;
      }
    prev = tmp;
    tmp = tmp->next;
   }
 fatal("SPECIAL_MEMLIST: No such pointer: %p", ptr);
}

void add_to_memlist(void* ptr)
{
 struct mem_list* newh;
 sdebug("%s:%d add_to_memlist",__FILE__,__LINE__);
 if (!mlist)
   {
    mlist = (struct mem_list*)malloc(sizeof(struct mem_list));
    if (!mlist) { fatal("malloc mlist failed!"); return; }
    mlist->ptr  = ptr;
    mlist->next = NULL;
    return;
   }
 newh = (struct mem_list*)malloc(sizeof(struct mem_list));
 if (!newh) { fatal("malloc mlist failed!"); return; }
 newh->ptr   = ptr;
 newh->next  = mlist;
 mlist       = newh; 
}


void print_memlist()
{
#ifdef NO_TRACE_MEM
 return ;
#else
 struct mem_list* tmp;
 sdebug("%s:%d print_memlist",__FILE__,__LINE__);
 tmp = mlist;
 printf("MEMLIST:\n");
 while (tmp)
   {
    printf("%p\n", tmp->ptr);
    tmp = tmp->next;
   }
 printf("MEMLIST END\n");
#endif
}

void del_from_memlist(void* ptr)
{
 struct mem_list *tmp, *prev;
 sdebug("%s:%d del_from_memlist",__FILE__,__LINE__);
 tmp = prev = mlist;
 while (tmp)
   {
    if (tmp->ptr==ptr)
      {
       if (tmp==mlist)
         {
          mlist = tmp->next;
	  free(tmp);
	  tmp = NULL;
	  return ;
         }
       prev->next = tmp->next;
       free(tmp);
       tmp = NULL;
       return ;
      }
    prev = tmp;
    tmp = tmp->next;
   }
 fatal("MEMLIST: No such pointer: %p", ptr);
}

void shred_memlist()
{
#ifdef NO_TRACE_MEM
 return;
#else
 struct mem_list *tmp, *prev;
 sdebug("%s:%d shred_memlist",__FILE__,__LINE__);
 tmp = prev = mlist;
 while (tmp)
   {
    prev = tmp;
    tmp = tmp->next;
    free(prev);
    prev = NULL;
   }
 mlist = NULL;
#endif
}

void shred_special_memlist(struct mem_list** head)
{
#ifdef NO_TRACE_MEM
 return ;
#else
 struct mem_list *tmp, *prev;
 sdebug("%s:%d shred_special_memlist",__FILE__,__LINE__);
 tmp = prev = *head;
 while (tmp)
   {
    prev = tmp;
    tmp = tmp->next;
    free(prev);
    prev = NULL;
   }
 *head = NULL;
#endif
}

void* mmalloc(int siz)
{
#ifdef NO_TRACE_MEM
 return malloc(siz);
#else
 void* ptr;
 sdebug("%s:%d mmalloc",__FILE__,__LINE__);
 if (siz<=0) fatal("mmalloc: want negative memory or zero memory: %d", siz);
 ptr = malloc(siz);
 if (!ptr) { gtk_dialog_printf("mmalloc failed!"); fatal("mmalloc failed"); return NULL; }
 add_to_memlist(ptr);
 return ptr;
#endif
}

void mfree(void** ptr)
{
#ifdef NO_TRACE_MEM
 free(*ptr);
#else
 sdebug("%s:%d mfree",__FILE__,__LINE__);
 del_from_memlist(*ptr);
 if (*ptr) free(*ptr);
 *ptr = NULL;
#endif
}

void* smalloc(struct mem_list** headp, int siz)
{
#ifdef NO_TRACE_MEM
 return malloc(siz);
#else
 void* ptr;
 sdebug("%s:%d smalloc",__FILE__,__LINE__);
 if (siz<=0) fatal("smalloc: want negative memory or zero memory: %p:%d", (void*)headp, siz);
 ptr = malloc(siz);
 if (!ptr) { gtk_dialog_printf("smalloc failed!"); fatal("smalloc failed"); return NULL; }
 add_to_special_memlist(headp, ptr);
 return ptr;
#endif
}

void sfree(struct mem_list** headp, void** ptr)
{
#ifdef NO_TRACE_MEM
 free(*ptr);
#else
 sdebug("%s:%d sfree",__FILE__,__LINE__);
 del_from_special_memlist(headp, *ptr);
 if (*ptr) free(*ptr);
 *ptr = NULL;
#endif
}
/* VERY DEBUG ONES... */

void* dsmalloc(struct dmem_list** headp, int siz, char* file, int line)
{
#ifdef NO_TRACE_MEM
 return malloc(siz);
#else
 void* ptr;
 sdebug("%s:%d dsmalloc called from %s:%d, want %d bytes",__FILE__,__LINE__, file,line,siz);
 if (siz<=0) fatal("dsmalloc: want negative memory or zero memory: %p:%d, called from %s:%d", (void*)headp,siz,file,line);
 ptr = malloc(siz);
 if (!ptr) { gtk_dialog_printf("dsmalloc failed!"); fatal("dsmalloc failed"); return NULL; }
 dadd_to_special_memlist(headp, ptr,file,line,siz);
 return ptr;
#endif
}

void dsfree(struct dmem_list** headp, void** ptr, char* file, int line)
{
#ifdef NO_TRACE_MEM
 free(*ptr);
#else
 sdebug("%s:%d dsfree called from %s:%d",__FILE__,__LINE__,file,line);
 ddel_from_special_memlist(headp,*ptr,file,line);
 if (*ptr) free(*ptr);
 *ptr = NULL;
#endif
}
void dshred_special_memlist(struct dmem_list** head, char* file, int line)
{
#ifdef NO_TRACE_MEM
 return ;
#else
 struct dmem_list *tmp, *prev;
 sdebug("%s:%d dshred_special_memlist called from %s:%d",__FILE__,__LINE__,file,line);
 tmp = prev = *head;
 while (tmp)
   {
    prev = tmp;
    tmp = tmp->next;
    sdebug("freeing memory (%d bytes) allocated at: %s:%d", prev->file, prev->line, prev->count);
    free(prev);
    prev = NULL;
   }
 *head = NULL;
#endif
}

void dadd_to_special_memlist(struct dmem_list** head, void* ptr, char* file, int line, int size)
{
 struct dmem_list* newh;
 sdebug("%s:%d dadd_to_special_memlist called from <delegation> %s:%d, bytes: %d",__FILE__,__LINE__,file,line,size);
 if (!(*head))
   {
    *head = (struct dmem_list*)malloc(sizeof(struct dmem_list));
    if (!(*head)) { fatal("dsmalloc failed!"); return; }
    (*head)->ptr  = ptr;
    (*head)->next = NULL;
    (*head)->file = file;
    (*head)->line = line;
    (*head)->count = size;
    return;
   }
 newh = (struct dmem_list*)malloc(sizeof(struct dmem_list));
 if (!newh) { fatal("dsmalloc failed!"); return; }
 newh->ptr   = ptr;
 newh->next  = *head;
 newh->file = file;
 newh->line = line;
 newh->count = size;
 *head       = newh; 
}

void dprint_special_memlist(struct dmem_list* head, char* file, int line)
{
#ifdef NO_TRACE_MEM
 return;
#else
 struct dmem_list* tmp;
 sdebug("%s:%d dprint_special_memlist called from %s:%d",__FILE__,__LINE__,file,line);
 tmp = head;
 printf("DEBUG_MEMLIST_SPECIAL:\n");
 while (tmp)
   {
    printf("-->PTR:%p WHERE: %s:%d, COUNT: %d\n", tmp->ptr,tmp->file,tmp->line,tmp->count);
    tmp = tmp->next;
   }
 printf("DEBUG_MEMLIST_SPECIAL END\n");
#endif
}

void ddel_from_special_memlist(struct dmem_list** head, void* ptr, char* file, int line)
{
 struct dmem_list *tmp, *prev;
 sdebug("%s:%d ddel_from_special_memlist called from <delegation> %s:%d",__FILE__,__LINE__,file,line);
 tmp = prev = *head;
 while (tmp)
   {
    if (tmp->ptr==ptr)
      {
       if (tmp==(*head))
         {
          *head = tmp->next;
	  sdebug("deleted list head: %p, from:%s:%d, count:%d", tmp->ptr, tmp->file,tmp->line,tmp->count);
	  free(tmp);
	  tmp = NULL;
	  return ;
         }
       sdebug("deleted list element: %p, from:%s:%d, count:%d", tmp->ptr, tmp->file,tmp->line,tmp->count);
       prev->next = tmp->next;
       free(tmp);
       tmp = NULL;
       return ;
      }
    prev = tmp;
    tmp = tmp->next;
   }
 fatal("DEBUG_SPECIAL_MEMLIST: No such pointer: %p", ptr);
}

void* dmmalloc(int siz, char* file, int line)
{
#ifdef NO_TRACE_MEM
 return malloc(siz);
#else
 void* ptr;
 sdebug("%s:%d dmmalloc called from %s:%d, want %d bytes",__FILE__,__LINE__, file,line,siz);
 if (siz<=0) fatal("dmmalloc: want negative memory or zero memory: %p:%d, called from %s:%d", (void*)dmlist,siz,file,line);
 ptr = malloc(siz);
 if (!ptr) { gtk_dialog_printf("dmmalloc failed!"); fatal("dmmalloc failed"); return NULL; }
 dadd_to_memlist(ptr,file,line,siz);
 return ptr;
#endif
}

void dmfree(void** ptr, char* file, int line)
{
#ifdef NO_TRACE_MEM
 free(*ptr);
#else
 sdebug("%s:%d dmfree called from %s:%d",__FILE__,__LINE__,file,line);
 ddel_from_memlist(*ptr,file,line);
 if (*ptr) free(*ptr);
 *ptr = NULL;
#endif
}
void dshred_memlist(char* file, int line)
{
#ifdef NO_TRACE_MEM
 return ;
#else
 struct dmem_list *tmp, *prev;
 sdebug("%s:%d dmhred_memlist called from %s:%d",__FILE__,__LINE__,file,line);
 tmp = prev = dmlist;
 while (tmp)
   {
    prev = tmp;
    tmp = tmp->next;
    sdebug("freeing memory (%d bytes) allocated at: %s:%d", prev->file, prev->line, prev->count);
    free(prev);
    prev = NULL;
   }
 dmlist = NULL;
#endif
}

void dadd_to_memlist(void* ptr, char* file, int line, int size)
{
 struct dmem_list* newh;
 sdebug("%s:%d dadd_to_memlist called from <delegation> %s:%d, bytes: %d",__FILE__,__LINE__,file,line,size);
 if (!dmlist)
   {
    dmlist = (struct dmem_list*)malloc(sizeof(struct dmem_list));
    if (!dmlist) { fatal("dsmalloc failed!"); return; }
    dmlist->ptr  = ptr;
    dmlist->next = NULL;
    dmlist->file = file;
    dmlist->line = line;
    dmlist->count = size;
    return;
   }
 newh = (struct dmem_list*)malloc(sizeof(struct dmem_list));
 if (!newh) { fatal("dsmalloc failed!"); return; }
 newh->ptr   = ptr;
 newh->next  = dmlist;
 newh->file = file;
 newh->line = line;
 newh->count = size;
 dmlist       = newh; 
}

void dprint_memlist(char* file, int line)
{
#ifdef NO_TRACE_MEM
 return ;
#else
 struct dmem_list* tmp;
 sdebug("%s:%d dprint_memlist called from %s:%d",__FILE__,__LINE__,file,line);
 tmp = dmlist;
 printf("DEBUG_MEMLIST:\n");
 while (tmp)
   {
    printf("-->PTR:%p WHERE: %s:%d, COUNT: %d\n", tmp->ptr,tmp->file,tmp->line,tmp->count);
    tmp = tmp->next;
   }
 printf("DEBUG_MEMLIST END\n");
#endif
}

void ddel_from_memlist(void* ptr, char* file, int line)
{
 struct dmem_list *tmp, *prev;
 sdebug("%s:%d ddel_from_memlist called from <delegation> %s:%d",__FILE__,__LINE__,file,line);
 tmp = prev = dmlist;
 while (tmp)
   {
    if (tmp->ptr==ptr)
      {
       if (tmp==dmlist)
         {
          dmlist = tmp->next;
	  sdebug("deleted list head: %p, from:%s:%d, count:%d", tmp->ptr, tmp->file,tmp->line,tmp->count);
	  free(tmp);
	  tmp = NULL;
	  return ;
         }
       sdebug("deleted list element: %p, from:%s:%d, count:%d", tmp->ptr, tmp->file,tmp->line,tmp->count);
       prev->next = tmp->next;
       free(tmp);
       tmp = NULL;
       return ;
      }
    prev = tmp;
    tmp = tmp->next;
   }
 fatal("DEBUG_MEMLIST: No such pointer: %p", ptr);
}

