#import <Cocoa/Cocoa.h>
#import "PostgreSQL.h"
#import "TestDelegate.h"

/*
	First in psql
	
	\i '/where_you_copy_it/pgsqltest.sql'
	
	then run the program
*/

void dumpArray(NSArray *inArray)	{
	
		if (inArray == nil)
			return	;
			
	int i, n = [inArray count]	;
	
		printf("{")	;
		for (i=0;i<n;i++)	{
			id	item = [inArray objectAtIndex:i]	;
			
				if ([item isKindOfClass:[NSArray class]])	{
					dumpArray(item)	;
				}
				else	if ([item isKindOfClass:[NSString class]])	{
					printf("'%s'",[item cString])	;
				}
				else	{
					printf("%s",[[item description] cString])	;
				}
				if (i < n-1)
					printf(", ")	;
		}
		printf("}")	;
}

int main(int argc, const char *argv[])
{
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
	int	resultCode	;
	PostgreSQL	*pgsql = [[PostgreSQL alloc] init]	;
	TestDelegate	*notifyDelegate = [[TestDelegate alloc] init];
	BOOL	ok = [pgsql connectToDatabase:"pgsqltest" onHost:"localhost" login:"postgres" password:"postgres" return:&resultCode]	;
//	BOOL	ok = [pgsql connectAskingUser:&resultCode]	;
	BOOL	cmdExecuted	;
	

		if (!ok)	{
			NSLog(@"Error connecting %d",resultCode)	;
			return resultCode	;
		}
		
	BOOL isRunning;
	NSDictionary *dict	;
		
		dict = [PostgreSQL getVariables]	;
		if (dict != nil)
			[dict writeToFile:[[NSString stringWithCString:"~/pgsqlvariables.plist"] stringByExpandingTildeInPath] atomically:NO]	;
		
	NSLog(@"UniqueID %@",[pgsql uniqueID]);
		[pgsql setDelegate:notifyDelegate]	;
		
	NSLog([pgsql postgreSQLVersion]);
	NSLog([pgsql frameworkVersion])	;

		(void)[pgsql startNotificationFor:"tbl2" delegate:notifyDelegate userInfo:nil]	;
		
		[pgsql clearCommands]	;
		[pgsql makeCommand:"insert into tbl1 values(11)"];
		[pgsql executeCommand]	;

		do {
			isRunning = [[NSRunLoop currentRunLoop] runMode:NSDefaultRunLoopMode
						beforeDate:[NSDate dateWithTimeIntervalSinceNow:5.0]]	;
		} 
		while ( isRunning && ![notifyDelegate notificationReceived]);

		[pgsql clearCommands]	;
		[pgsql makeCommand:"select * from testtypes"];
		[pgsql executeCommand]	;

		dict = [pgsql resultAsDictionary]	;
		
		if (dict != nil)
			[dict writeToFile:[[NSString stringWithCString:"~/pgsqltest.plist"] stringByExpandingTildeInPath] atomically:NO]	;

		[pgsql beginTransaction];
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select * from testtypes"];
		[pgsql executeCommandWithCursor:"myCursor" binary:YES]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;

		dict = [pgsql resultAsDictionary]	;
		
		if (dict != nil)
			[dict writeToFile:[[NSString stringWithCString:"~/pgsqltest_bin.plist"] stringByExpandingTildeInPath] atomically:NO]	;

		[pgsql closeCursor:"myCursor"]	;
		[pgsql commitTransaction];
		
	NSLog(@"select p from testtypes where p is not null");
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select p from testtypes where p is not null"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			POLYGON *p	;
			
			[pgsql bindPolygon:&p]	;

			while ([pgsql nextRow])	{
				if (p)	{
					printf("%d %lf %lf %lf %lf\n",p->npts,p->boundbox.high.x,p->boundbox.high.y,p->boundbox.low.x,p->boundbox.low.y)	;
					free(p)	;
				}
			}
		}
		
	NSLog(@"select pth from testtypes where pth is not null");
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select pth from testtypes where pth is not null"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			PATH *p	;
			
			[pgsql bindPath:&p]	;
			while ([pgsql nextRow])	{
				if (p)	{
					printf("%d %d\n",p->npts,p->closed)	;
					free(p)	;
				}
			}
		}
		
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select ls from testtypes where ls is not null"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			LSEG ls	;
			
			[pgsql bindLSeg:&ls]	;
			while ([pgsql nextRow])	{
				printf("[(%lf, %lf),(%lf, %lf) slope %lf]\n",ls.p[0].x,ls.p[0].y,ls.p[1].x,ls.p[1].y,ls.m)	;
			}
		}
		
	NSLog(@"select t from testtypes where t is not null")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select t from testtypes where t is not null"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			TEXT textBuffer	;
			
			[pgsql bindText:&textBuffer]	;
			while ([pgsql nextRow])	{
				if (textBuffer.text)	{
					printf("%s\n",textBuffer.text)	;
					free(textBuffer.text);
				}
				else
					printf("NULL\n");
			}
		}
		
	NSLog(@"select fd_bytea from testtypes")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select fd_bytea from testtypes"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			BSTRING binaryBuffer	;
			
			[pgsql bindBinaryString:&binaryBuffer]	;
			while ([pgsql nextRow])	{
				if (binaryBuffer.bytes)	{
					int	i	;
					unsigned char *p = binaryBuffer.bytes	;
					
					for(i=0;i<binaryBuffer.size;i++,p++)
						printf("%X ",*p)	;
					printf("\n")	;
					free(binaryBuffer.bytes);
				}
				else
					printf("NULL\n");
			}
		}
		
	NSLog(@"select bx from testtypes where bc is not null")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select bx from testtypes where bx is not null"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			BOX bx	;
			
			[pgsql bindBox:&bx]	;
			while ([pgsql nextRow])	{
				printf("(%lf, %lf),(%lf, %lf)\n",bx.high.x,bx.high.y,bx.low.x,bx.low.y)	;
			}
		}
		
	NSLog(@"select ci from testtypes where ci is not null")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select ci from testtypes where ci is not null"];
		[pgsql executeCommand]	;
		
		if ([pgsql rowsAffected])	{
			CIRCLE ci	;
			
			[pgsql bindCircle:&ci]	;
			while ([pgsql nextRow])	{
				printf("<(%lf, %lf),%lf>\n",ci.center.x,ci.center.y,ci.radius)	;
			}
		}
		
	NSLog(@"Testing transaction")	;
	NSLog(@"select bx from testtypes")	;
		
		[pgsql beginTransaction]	;

		[pgsql clearCommands]	;
		[pgsql makeCommand:"select bx from testtypes"];

		[pgsql executeCommandWithCursor:"myCursor" binary:YES]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;

		if ([pgsql rowsAffected])	{
			BOX bx	;
			
			[pgsql bindBox:&bx]	;
			while ([pgsql nextRow])	{
				printf("(%lf, %lf),(%lf, %lf)\n",bx.high.x,bx.high.y,bx.low.x,bx.low.y)	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;

	NSLog(@"select fd_num, fd_num_32_6 from testtypes")	;
		
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select fd_num, fd_num_32_6 from testtypes"];

		[pgsql executeCommandWithCursor:"myCursor" binary:YES]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;

		if ([pgsql rowsAffected])	{
			double d1	;
			NSDecimalNumber	*d2	;
			
			[pgsql bindDouble:&d1]	;
			[pgsql bindNSDecimal:&d2]	;
			while ([pgsql nextRow])	{
				printf("%lf\n",d1)	;
				NSLog(@"NSDecimalNumber %@",[d2 stringValue])	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;

	NSLog(@"select ci from testtypes")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select ci from testtypes"];
		[pgsql executeCommandWithCursor:"myCursor" binary:NO]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;

		if ([pgsql rowsAffected])	{
			CIRCLE ci	;
			
			[pgsql bindCircle:&ci]	;
			while ([pgsql nextRow])	{
				printf("<(%lf, %lf),%lf>\n",ci.center.x,ci.center.y,ci.radius)	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;

	NSLog(@"select fd_intarray, fd_floatarray, fd_bchar_array from testtypes BINARY CURSOR")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select fd_intarray, fd_floatarray, fd_bchar_array from testtypes"];
		[pgsql executeCommandWithCursor:"myCursor" binary:YES]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;
		if ([pgsql rowsAffected])	{
			NSArray	*intArray	;
			NSArray	*floatArray	;
			NSArray	*stringArray	;
			
			[pgsql bindNSArray:&intArray]	;
			[pgsql bindNSArray:&floatArray]	;
			[pgsql bindNSArray:&stringArray]	;
			while ([pgsql nextRow])	{
				dumpArray(intArray)	;
				printf("\n")	;
				dumpArray(floatArray)	;
				printf("\n")	;
				dumpArray(stringArray)	;
				printf("\n")	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;

	NSLog(@"select fd_intarray, fd_floatarray, fd_bchar_array from testtypes TEXT CURSOR")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select fd_intarray, fd_floatarray, fd_bchar_array from testtypes"];
		[pgsql executeCommandWithCursor:"myCursor" binary:NO]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;
		if ([pgsql rowsAffected])	{
			NSArray	*intArray	;
			NSArray	*floatArray	;
			NSArray	*stringArray	;
			
			[pgsql bindNSArray:&intArray]	;
			[pgsql bindNSArray:&floatArray]	;
			[pgsql bindNSArray:&stringArray]	;
			while ([pgsql nextRow])	{
				dumpArray(intArray)	;
				printf("\n")	;
				dumpArray(floatArray)	;
				printf("\n")	;
				dumpArray(stringArray)	;
				printf("\n")	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;
		
	NSLog(@"select fd_inet, fd_cidr, fd_macaddr, fd_bit100 from testtypes BINARY CURSOR")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select fd_inet, fd_cidr, fd_macaddr, fd_bit100 from testtypes"];
		[pgsql executeCommandWithCursor:"myCursor" binary:YES]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;

		if ([pgsql rowsAffected])	{
			unsigned char inet[12]	;
			unsigned char cidr[12]	;
			unsigned char macaddr[6]	;
			BOOLARRAY	boolArray	;
			BOOL 	*bit	;
			int		i	;
			
			[pgsql bindInet:inet]	;
			[pgsql bindCIdr:cidr]	;
			[pgsql bindMACaddr:macaddr]	;
			[pgsql bindBIT:&boolArray]	;
			while ([pgsql nextRow])	{
				printf("%X %X %X %X %X %X %X %X %X %X %X %X \n", inet[0],inet[1],inet[2],inet[3],inet[4],inet[5],inet[6],inet[7],inet[8],inet[9],inet[10],inet[11])	;
				printf("%X %X %X %X %X %X %X %X %X %X %X %X \n", cidr[0],cidr[1],cidr[2],cidr[3],cidr[4],cidr[5],cidr[6],cidr[7],cidr[8],cidr[9],cidr[10],cidr[11])	;
				printf("%X %X %X %X %X %X\n", macaddr[0],macaddr[1],macaddr[2],macaddr[3],macaddr[4],macaddr[5])	;
				
				if (boolArray.bits)	{
					for(i=0,bit = boolArray.bits;i<boolArray.size;i++,bit++)	{
						printf("%c",(*bit)? '1':'0');
					}
					printf("\n")	;
					free(boolArray.bits);
				}
				else
					printf("NULL\n")	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;

	NSLog(@"select fd_inet, fd_cidr, fd_macaddr, fd_bit100 from testtypes NO BINARY")	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"select fd_inet, fd_cidr, fd_macaddr, fd_bit100 from testtypes"];
		[pgsql executeCommandWithCursor:"myCursor" binary:NO]	;
		[pgsql clearCommands]	;
		[pgsql makeCommand:"FETCH ALL in myCursor"]	;
		[pgsql executeCommand]	;

		if ([pgsql rowsAffected])	{
			unsigned char inet[12]	;
			unsigned char cidr[12]	;
			unsigned char macaddr[6]	;
			BOOLARRAY	boolArray	;
			BOOL 	*bit	;
			int		i	;
			
			[pgsql bindInet:inet]	;
			[pgsql bindCIdr:cidr]	;
			[pgsql bindMACaddr:macaddr]	;
			[pgsql bindBIT:&boolArray]	;
			while ([pgsql nextRow])	{
				printf("%X %X %X %X %X %X %X %X %X %X %X %X \n", inet[0],inet[1],inet[2],inet[3],inet[4],inet[5],inet[6],inet[7],inet[8],inet[9],inet[10],inet[11])	;
				printf("%X %X %X %X %X %X %X %X %X %X %X %X \n", cidr[0],cidr[1],cidr[2],cidr[3],cidr[4],cidr[5],cidr[6],cidr[7],cidr[8],cidr[9],cidr[10],cidr[11])	;
				printf("%X %X %X %X %X %X\n", macaddr[0],macaddr[1],macaddr[2],macaddr[3],macaddr[4],macaddr[5])	;

				if (boolArray.bits)	{
					for(i=0,bit = boolArray.bits;i<boolArray.size;i++,bit++)	{
						printf("%c",(*bit)? '1':'0');
					}
					printf("\n")	;
					free(boolArray.bits);
				}
				else
					printf("NULL\n")	;
			}
		}
		[pgsql closeCursor:"myCursor"]	;

		[pgsql commitTransaction]	;

	NSLog(@"Testing asynchronous query")	;

		[pgsql clearCommands]	;
		[pgsql makeCommand:"select _rowid from testtypes"];
		cmdExecuted = [pgsql executeAsyncCommand]	;
		
		do {
			isRunning = [[NSRunLoop currentRunLoop] runMode:NSDefaultRunLoopMode
						beforeDate:[NSDate dateWithTimeIntervalSinceNow:5.0]]	;
						
			if (!cmdExecuted)	{
				NSLog(@"waiting for async to be ready")	;
				cmdExecuted = [pgsql executeAsyncCommand]	;
			}
			else
				NSLog(@"waiting for async results")	;
		} 
		while ( isRunning && ![pgsql asyncResultAvailable]);
		
		if ([pgsql asyncResultAvailable])	{
			long long		rowid	;
			
			[pgsql bindLongLong:&rowid]	;
			
			while ([pgsql nextRow])	{
				printf("%lld\n",rowid)	;
			}
		}

		[pool release];
		return 0;
}
