#import "LoginWindowController.h"
#import "PostgreSQL.h"

@implementation LoginWindowController

- (id)init
{
		self = [super init]	;
		_connected = NO	;
		_defaults = nil	;
		return [self initWithWindowNibName:@"Login"];
}

- (id)initWithDefaults:(NSDictionary *)defaults
{
		self = [self init]	;
		
		_defaults = [defaults retain]	;
		
		return self	;
}

-(void)dealloc
{
		[_defaults release]	;
		[super dealloc]		;
}

-(void)awakeFromNib
{
	id			item	;
	
		if (_defaults == nil)
			return	;
			
		item = [_defaults objectForKey:@"hostname"]	;
		if (item != nil)	{
			[hostName setStringValue:[item description]]	;
		}

		item = [_defaults objectForKey:@"port"]	;
		if (item != nil)	{
			[portNum setStringValue:[item description]]	;
		}

		item = [_defaults objectForKey:@"dbname"]	;
		if (item != nil)	{
			[databaseName setStringValue:[item description]]	;
		}

		item = [_defaults objectForKey:@"user"]	;
		if (item != nil)	{
			[userName setStringValue:[item description]]	;
		}

		item = [_defaults objectForKey:@"password"]	;
		if (item != nil)	{
			[password setStringValue:[item description]]	;
		}
}

- (IBAction)doCancel:(id)sender
{
		[NSApp stopModal]	;
}

- (IBAction)doConnect:(id)sender
{
	NSMutableString	*command = [NSMutableString string]	;
	NSString	*aString	;
	
		aString = [hostName stringValue]	;
		if ([aString length])
			[command appendString:[NSString stringWithFormat:@"host='%@' ",aString]]	;
			
		aString = [portNum stringValue]	;
		if ([aString length])
			[command appendString:[NSString stringWithFormat:@"port='%@' ",aString]]	;
	
		aString = [databaseName stringValue]	;
		if ([aString length])
			[command appendString:[NSString stringWithFormat:@"dbname='%@' ",aString]]	;
	
		aString = [userName stringValue]	;
		if ([aString length])
			[command appendString:[NSString stringWithFormat:@"user='%@' ",aString]]	;
	
		aString = [password stringValue]	;
		if ([aString length])
			[command appendString:[NSString stringWithFormat:@"password='%@' ",aString]]	;
	
		aString = [options stringValue]	;
		if ([aString length])
			[command appendString:[NSString stringWithFormat:@"options='%@' ",aString]]	;
	
		if (_connected = [_connection connectToDatabase:[command cString] return:&_errorCode])
			[NSApp stopModal]	;
		else	{
			[errorMessage setStringValue:[NSString stringWithCString:[_connection connectErrorMessage:_errorCode]]]	;
		}
}

-(void)setConnection:(PostgreSQL *)inConnection
{
		_connection = inConnection	;
}

-(BOOL)connectionOK
{
		return _connected	;
}

-(int)errorCode
{
		return _errorCode	;
}

@end
