<?
/* (c) 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */
/* with contribution for the script structure 
   from categories.php (c) 2000 Ying Zhang (ying@zippydesign.com) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = $Brands_Management;
include("templates/header.ihtml");

switch (nvl($mode)) {
	case "add" :
		print_add_brand_form();
		break;

	case "edit" :
		if (!($id == 0))
			print_edit_brand_form($id);
		break;

	case "del" :
		if (!($id == 0))
			delete_brand($id);
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_brand_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_brand_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_brand($HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "insert";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = $Add_Brand;
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/brand_form.ihtml");
		}
		break;

	case "update" :
		if ($id == 0)
			break;
		$errors = new Object;
		$errormsg = "";
		validate_brand_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_brand_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_brand($id, $HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "update";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = $Save_Changes;
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/brand_form.ihtml");
		}
		break;

	case "import" :
		print_import_brands_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_brand_form();
		else
			import_brands($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_brands_list();
		break;
}

include("templates/footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function print_add_brand_form() {
/* print a blank brand form so we can add a new brand */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	/* set default values for the reset of the fields */
	$frm["newmode"] = "insert";
	$frm["name"] = "";
	$frm["description"] = "";
	$frm["submit_caption"] = $Add_Brand;

	include("templates/brand_form.ihtml");
}

function print_edit_brand_form($id) {
/* print a brand form so we can edit the selected brand */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	/* load up the information for the brand */
	$qid = db_query("
	SELECT name, description
	FROM brands
	WHERE id = '$id'
	");
	$frm = db_fetch_array($qid, 0);

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;

	include("templates/brand_form.ihtml");
}

function delete_brand($id) {
// delete the brand specified by $id, and reset to 0
// the brand_id for all products of this brand

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_begin();

	/* find out the brand name */
	$qid = db_query("
	SELECT name from brands
	WHERE id = '$id'
	");
	$frm = db_fetch_array($qid, 0);

	/* delete this brand */
	$qid = db_query("
	DELETE FROM brands
	WHERE id = '$id'
	");

	// reset to 0 the brand_id for all products of this brand
	$qid = db_query("
	UPDATE products SET brand_id = 0 WHERE brand_id = '$id'
	");

	$qid = db_commit();

	include("templates/brand_deleted.ihtml");
}

function insert_brand($frm) {
/* add a new brand.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	INSERT INTO brands (name, description)
	VALUES ('$frm[name]', '$frm[description]')
	");

	include("templates/brand_added.ihtml");
}

function update_brand($id, $frm) {
/* update the brand $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	UPDATE brands SET
		name = '$frm[name]'
		,description = '$frm[description]'
	WHERE id = '$id'
	");

	include("templates/brand_updated.ihtml");
}

function print_brands_list() {
/* read all the brands from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT id, name, description
		FROM brands
		WHERE id > 0
		ORDER BY name
		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["brands"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["brands_per_page"]) {
		$first = ($page_number-1)*$SESSION["brands_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["brands_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["brands_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["brands_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	include("templates/brand_list.ihtml");
}

function print_import_brands_form() {
/* print the import brand form so we can add/update brands from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* set values for the form */
	$frm["submit_caption"] = $Import_Button_Label;
	$frm["newmode"] = "update_imp";

	include("templates/data_import.ihtml");
}

function import_brands($userfile) {
/* Import brands from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);
	$errors = new Object;

	$qid = db_begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* dangerous characters quoting */
		for ($i=0; $i<2; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* ... and let's see if the brand already exists ... */
		$qid = db_query("
		SELECT id, name FROM brands WHERE name = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's create it ... */
			$qid = db_query("
			INSERT INTO brands (name, description)
			VALUES ('$fldarr[0]', '$fldarr[1]')
			");
		} else {
			/* ... otherwise let's save its ID ... */
			$arr = db_fetch_array($qid,0);
			$sid = $arr[0];
			/* ... and update ... */
			$qid = db_query("
			UPDATE brands SET
				name = '$fldarr[0]'
				,description = '$fldarr[1]'
			WHERE id = '$sid'
			");
		}
	}

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	include("templates/data_import_end.ihtml");

}

?>
