/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "groupitempopup.h"
#include "grouppropertiesform.h"
#include "serverlistviewitem.h"

	/**
	 * Constructor
	 */
	GroupItemPopup::GroupItemPopup(QWidget *pqoParent, GroupListViewItem *poGroupListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poGroupListViewItem = poGroupListViewItem;	// keep a reference to the Group item
		
		// setup all the items and their slots
		insertItem("Add Server", this, SLOT(createServerItem()));
		insertItem("Edit Properties", this, SLOT(editProperties()));		
		insertSeparator();
		insertItem("Delete", this, SLOT(deleteGroupItem()));		
	} // end constructor

	/**
	 * Used to get a reference to the database item that this popup was generated from.
	 */
	GroupListViewItem * GroupItemPopup::getGroupListViewItem() const
	{
		return m_poGroupListViewItem;
	} // end getGroupListViewItem

	/**
 	 * This slot is called by the popup menu itself when new server is called
   */	
	void GroupItemPopup::createServerItem()
	{
		ServerListViewItem *poServerItem = new ServerListViewItem(m_poGroupListViewItem);
		QString qstrServer1("New Server");
		poServerItem->setText(0, qstrServer1);		
		
		if (m_poGroupListViewItem->hasExpanded() == true)
		{
			// lets init children for new database
			poServerItem->initChildren();
		} // end if already expanded as well

		// lets open up the list
		m_poGroupListViewItem->setOpen(true);
				
		m_poGroupListViewItem->listView()->setSelected(poServerItem, true);
	
	} // end createDatabaseConnection
	
	/**
 	 * This slot is called by the popup menu itself when edit properties is selected.
   */	
	void GroupItemPopup::editProperties()
	{
		GroupPropertiesForm * poGroupPropertiesForm = new GroupPropertiesForm(this);
		poGroupPropertiesForm->show();
	} // end editProperties
	
	/**
	 * This slot is called by the popup menu itself when delete group is selected.
	 */
	void GroupItemPopup::deleteGroupItem()
	{
		delete m_poGroupListViewItem;
	} // end deleteGroupItem
	
