/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBTRIGGER_H
#define DBTRIGGER_H

#include <string>
#include <vector>
#include "../../../exceptions/indexoutofrangeexception.h"

/**
 * This class is used to represent a database table trigger.
 */
class DBTrigger
{

protected:
	string m_strTriggerName;
	string m_strTableName;
	string m_strProcedureName;
	string m_strTriggerComment;
	vector<string> m_vstrTriggerArguments;
	int m_nTriggerType;
	bool m_bConstraint;
				
public:

	/**
	 * The types of triggers.
	 */
	const static int AFTER_INSERT;
	const static int BEFORE_INSERT;	
	const static int AFTER_DELETE;	
	const static int BEFORE_DELETE;	
	const static int AFTER_UPDATE;
	const static int BEFORE_UPDATE;
				
	/**
 	 * Constructor
   */		
	DBTrigger();
	
	/**
 	 * Destructor
   */		
	~DBTrigger();
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
	
	/**
 	 * Used to set the trigger name.
   */			    	
	void setTriggerName(const string &rstrTriggerName);

	/**
 	 * Used to retrieve the trigger name.
   */			    			
	const string & getTriggerName() const;

	/**
 	 * Used to set the table name.
   */			    						
	void setTableName(const string &rstrTableName);

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & getTableName() const;			

	/**
 	 * Used to set the procedure name.
   */			    						
	void setProcedureName(const string &rstrProcedureName);

	/**
 	 * Used to retrieve the Procedure name.
   */			    			
	const string & getProcedureName() const;			

	/**
 	 * Used to add the trigger argument. These are used by the constraint triggers.
   */			    						
	void addTriggerArgument(const string & rstrTriggerArgument);

	/**
 	 * Used to retrieve a trigger argument. These are used by the constraint triggers.
   */			    			
	const string & getTriggerArgument(int nArgIndex) const throw (IndexOutOfRangeException);
	
	/**
	 * Used to get the number of trigger arguments for this trigger.
	 */
	int getNumberOfArguments() const; 			
		
	/**
 	 * Used to set the constraint property.
   */			    						
	void setConstraint(bool bConstraint);

	/**
 	 * Used to get the constraint property.
   */			    						
	bool isConstraint() const;
	
	/**
 	 * Used to set the trigger type.
   */			    						
	void setTriggerType(int nTriggerType);

	/**
 	 * Used to get the trigger type.
   */			    						
	int getTriggerType() const;

	/**
 	 * Used to retrieve a trigger comment.
   */			    			
	const string & getTriggerComment() const;			

	/**
 	 * Used to set a trigger comment.
   */			    			
	void setTriggerComment(const string &rstrComment);			
			
};

#endif

