/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBINDEXMANAGER_H
#define DBINDEXMANAGER_H

#include <string>
#include "../../../exceptions/sqlexception.h"
#include "dbindexset.h"
#include "../../dbconnection.h"
#include "../../dbbasemanager.h"
#include "dbindexset.h"

/**
 * This class is used to manage operations concerning database indicies. The class
 * provides many generic functions that can be used to retrieve/create/modify
 * database indicies.
 */
class DBIndexManager : public DBBaseManager
{
					
public:

	/**
 	 * Constructor
   */		
  DBIndexManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBIndexManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBIndexManager();

	/**
	 * Used to retrieve the list of indicies for current table.
	 * @return	a DBIndexSet object that contains the index details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfIndicies(const string & rstrTableName, DBIndexSet & roDBIndexSet, bool bOnlyPrimary = false)
				throw (SQLException, DBConnectionException);

	/**
	 * Used to modify the index comment.
	 * @param			rstrIndexName		the name of the index
	 * @param			rstrComment			the comment to set for the index
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void modifyIndexComment(const string & rstrIndexName, const string & rstrComment)
				throw (SQLException, DBConnectionException);
						
};

#endif

