/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBTABLESCHEMA_H
#define DBTABLESCHEMA_H

#include <string>
#include <vector>
#include "dbtablecolumn.h"
#include "../../exceptions/indexoutofrangeexception.h"

/**
 * This class is used to represent a database schema.
 */
class DBTableSchema
{			
protected:
	string m_strTableName;
	// this is used to hold the column details
	vector<DBTableColumn> m_voTableColumns;
								
public:
	
	/**
 	 * Constructor
   */		
	DBTableSchema();
	
	/**
 	 * Destructor
   */		
	~DBTableSchema();
	
	/**
	 * Used to clear the table schema contents.
	 * This should be called when the table schema needs to be reused.
	 */
	void clear();
		
	/**
 	 * Used to set the table name.
   */			    	
	void setTableName(const string &rstrTableName);

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & getTableName() const;

	/**
 	 * Used to get the number of columns.
   */			    			
	int getNumberOfColumns() const;
	
	/**
 	 * Used to add a column. This will append the column to the end of the list.
   */			    						
	void addColumn(const DBTableColumn & roDBTableColumn);

	/**
 	 * Used to retrieve a column.
   */			    			
	const DBTableColumn & getColumn(int nFieldIndex) const throw (IndexOutOfRangeException);			
	 						
};

#endif

