/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbtable.h"
	
	/**
 	 * Constructor
   */		
	DBTable::DBTable()
	{
		clear();
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBTable::~DBTable()
	{
		// do nothing
	} // end destructor

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBTable::clear()
	{
		m_strTableName = "";
		m_strTableComment = "";
		m_strTableOwner = "";		
	} // end clear
		
	/**
 	 * Used to set the table name.
   */			    	
	void DBTable::setTableName(const string &rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & DBTable::getTableName() const
	{
		return m_strTableName;
	} // end getTableName

	/**
 	 * Used to set the table comment.
   */			    						
	void DBTable::setTableComment(const string &rstrComment)
	{
		m_strTableComment = rstrComment;
	} // end setTableComment

	/**
 	 * Used to retrieve the table comment.
   */			    			
	const string & DBTable::getTableComment() const
	{
		return m_strTableComment;
	} // end getTableDescription

	/**
 	 * Used to set the table owner.
   */			    						
	void DBTable::setTableOwner(const string &rstrOwner)
	{
		m_strTableOwner = rstrOwner;
	} // end setTableOwner

	/**
 	 * Used to retrieve the table owner.
   */			    			
	const string & DBTable::getTableOwner() const
	{
		return m_strTableOwner;
	} // end getTableOwner

