/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "viewgrouplistviewitem.h"
#include "viewlistviewitem.h"
#include "viewgroupitempopup.h"
#include "../common/infodialogs.h"
#include "../../utils/debugger.h"
#include "../../dataaccess/views/dbviewmanager.h"
#include "../../dataaccess/views/dbviewset.h"

#include <iostream.h>

	ViewGroupListViewItem::ViewGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		setText(0, "Views");
		m_qstrDescription = "<h1>Views</h1><hr><p>Lists all the views and its properties in this database.</p>";
	} // end constructor

	ViewGroupListViewItem::ViewGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		setText(0, "Views");
		m_qstrDescription = "<h1>Views</h1><hr><p>Lists all the views and its properties in this database.</p>";	
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void ViewGroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "ViewGroupListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new ViewGroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
	
					
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void ViewGroupListViewItem::initChildren()
	{	
		string strMethodName = "ViewGroupListViewItem::initChildren";
		
		Debugger::entered(strMethodName);

		// temporary view set
		DBViewSet oDBViewSet;
		
		try
		{		
			getDBMasterManager()->getDBViewManager()->retrieveListOfViews(oDBViewSet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);
				// report error to user
			InfoDialogs::infoSQLException(listView(), e);								
			return;
		} // end catch
		while (oDBViewSet.next())
		{
			ViewListViewItem *poViewItem = new ViewListViewItem(this);
			// retrieve view details
			oDBViewSet.getDBView(*poViewItem);
			poViewItem->setText(0, poViewItem->getViewName().c_str());					
			// set database connection
			poViewItem->setDBMasterManager(getDBMasterManager());
			// lets update the description
			poViewItem->updateDescription();
		} // end while more
				
		Debugger::exited(strMethodName);		
	} // end initChildren
	