/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef INDEXGROUPITEMPOPUP_H
#define INDEXGROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "indexgrouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a Index group item in the list viewer.
 */
class IndexGroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	IndexGroupListViewItem * m_poIndexGroupItem;	
	
public:
	/**
	 * Constructor
	 */
	IndexGroupItemPopup(QWidget *pqoParent, IndexGroupListViewItem *poIndexGroupItem);

	/**
	 * Used to access the Index group list view item.
	 */
	IndexGroupListViewItem * getIndexGroupListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the Index list.
   */	
	void refreshListOfIndicies();
		
};


#endif

