/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "grouppropertiesform.h"
#include "grouplistviewitem.h"
#include "groupitempopup.h"
#include "mainlistview.h"
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qcheckbox.h>

	/**
 	 * Constructor
   */		
  GroupPropertiesForm::GroupPropertiesForm(QWidget* pqoParent)
  	: UicGroupPropertiesForm(pqoParent)
  {
		// lets update all the group fields
  	GroupListViewItem *poGroupListViewItem = ((GroupItemPopup*)parentWidget())->getGroupListViewItem();
		
  	QString qstrTemp = (poGroupListViewItem->getGroupName()).c_str();
  	m_pqtxtGroupName->setText(qstrTemp);  	
  	qstrTemp = (poGroupListViewItem->getGroupDescription()).c_str();
  	m_pqtxtDescription->setText(qstrTemp);  	

  } // end constructor

	/**
	 * This method is used to save group properties.
	 */
	void GroupPropertiesForm::saveGroupProperties()
	{
		// lets update all the Group fields
  	GroupListViewItem *poGroupListViewItem = ((GroupItemPopup*)parentWidget())->getGroupListViewItem();
		
  	poGroupListViewItem->setGroupName((m_pqtxtGroupName->text()).latin1());  	
  	poGroupListViewItem->setGroupDescription(m_pqtxtDescription->text().latin1());
		
		// lets update the list view name
		poGroupListViewItem->setText(0, m_pqtxtGroupName->text());
		
  	// update the details
  	poGroupListViewItem->updateDescription();		  	
		// lets signal to change the description
		((MainListView*)(poGroupListViewItem->listView()))->changeItemDescription(poGroupListViewItem);
		
		close(true);	// lets close the form
		
	} // end saveGroupProperties

	/**
	 * This method is used to close the form.
	 */
	void GroupPropertiesForm::closeForm()
	{
		close(true);
	} // end closeForm