/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "databaseitempopup.h"
#include "databaseconnectform.h"

	/**
	 * Constructor
	 */
	DatabaseItemPopup::DatabaseItemPopup(QWidget *pqoParent, DatabaseListViewItem *poDatabaseListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poDatabaseListViewItem = poDatabaseListViewItem;	// keep a reference to the Database item
		
		// setup all the items and their slots
		insertItem("Reconnect", this, SLOT(reconnect()));
		insertItem("Edit Properties", this, SLOT(editProperties()));		
		insertSeparator();
		insertItem("Delete", this, SLOT(deleteDatabaseItem()));
	} // end constructor

	/**
	 * Used to get a reference to the database item that this popup was generated from.
	 */
	DatabaseListViewItem * DatabaseItemPopup::getDatabaseListViewItem() const
	{
		return m_poDatabaseListViewItem;
	} // end getDatabaseListViewItem

	/**
 	 * This slot is called by the popup menu itself when reconnect is called.
   */	
	void DatabaseItemPopup::reconnect()
	{
		m_poDatabaseListViewItem->refreshList();
		m_poDatabaseListViewItem->initGrandChildren();
	} // end reconnect
		
	/**
 	 * This slot is called by the popup menu itself when edit properties is selected.
   */	
	void DatabaseItemPopup::editProperties()
	{
		DatabaseConnectForm * poConnectForm = new DatabaseConnectForm(this, false, false);
		poConnectForm->show();
	} // end editProperties

	/**
	 * This slot is called by the popup menu itself when delete database is selected.
	 */
	void DatabaseItemPopup::deleteDatabaseItem()
	{
		delete m_poDatabaseListViewItem;
	} // end deleteDatabaseItem
	
