/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbforeignkeymanager.h"
#include "../../../utils/debugger.h"
#include "../triggers/dbtriggermanager.h"
#include "../triggers/dbtriggerset.h"

	/**
 	 * Constructor
	 */
  DBForeignKeyManager::DBForeignKeyManager()
  	: DBBaseManager()
	{
  } // end constructor
	
	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBForeignKeyManager::DBForeignKeyManager(DBConnection *poDBConn)
  	: DBBaseManager(poDBConn)
  {
  } // end constructor
	
	/**
 	 * Destructor
   */		
	DBForeignKeyManager::~DBForeignKeyManager()
	{
		// do nothing
	} // end destructor

	/**
	 * Used to retrieve the list of foreign keys for the specified table.
	 * @return	a DBForeignKeySet object that contains the foreign key details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void DBForeignKeyManager::retrieveListOfForeignKeys(const string & rstrTableName, DBForeignKeySet & roDBForeignKeySet)
		 throw (SQLException, DBConnectionException)
	{
		string strMethodName = "DBForeignKeyManager::retrieveListOfForeignKeys";
		
		Debugger::entered(strMethodName);
		
		// need to create trigger manager to get foreign keys
		// NOTE: Current postgres implementation uses triggers to handle foreign keys
		DBTriggerManager oDBTriggerMgr(m_poDBConn);
		oDBTriggerMgr.retrieveListOfTriggers(rstrTableName, roDBForeignKeySet.m_oDBTriggerSet, true);
				
		Debugger::exited(strMethodName);
			
	} // end retrieveListOfTriggers
