/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DATABASEITEMPOPUP_H
#define DATABASEITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "databaselistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a database item in the list viewer.
 */
class DatabaseItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	DatabaseListViewItem * m_poDatabaseListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	DatabaseItemPopup(QWidget *pqoParent, DatabaseListViewItem *poDatabaseListViewItem);

	/**
	 * Used to get a reference to the database item that this popup was generated from.
	 */
	DatabaseListViewItem * getDatabaseListViewItem() const;
	
protected slots:
	/**
 	 * This slot is called by the popup menu itself when reconnect is called.
   */	
	void reconnect();
	
	/**
 	 * This slot is called by the popup menu itself when edit properties is selected.
   */	
	void editProperties();
	
	/**
	 * This slot is called by the popup menu itself when delete database is selected.
	 */
	void deleteDatabaseItem();
	
};


#endif

