/*
 * TreeControl.java
 *
 * Created on 22 de julio de 2002, 12:50
 */
package components;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.util.*;
import frames.*;
import pgclibrary.objects.*;
import components.treeObjects.*;

/**
 *
 * @author  nestor
 */
public class TreeControl extends JTree {
    private Database database = null;
    private PrincipalFrame frame = null;
    
    /** Creates a new instance of TreeControl */
    public TreeControl(PrincipalFrame _frame) {
        super(new TreeControlModel(new RootElement(_frame.getDatabase())));
        
        frame = _frame;
        database = _frame.getDatabase();
        setEditable(false);
        setScrollsOnExpand(true);
        
        setShowsRootHandles(true);
        putClientProperty("JTree.lineStyle", "Angled");
        getSelectionModel().setSelectionMode(getSelectionModel().SINGLE_TREE_SELECTION);
        
        setCellRenderer(new TreeControlCellRenderer());
        
        addTreeSelectionListener(new TreeSelectionListener(){
            public void valueChanged(TreeSelectionEvent e){
                if(getLastSelectedPathComponent() != null){
                    TreeInfo tmp = (TreeInfo) getLastSelectedPathComponent();
                    frame.updateSelectedObject(tmp);
                }
            }
        }
        );
    }
    
    public TreeInfo getRoot(){
        return (TreeInfo) getModel().getRoot();
    }
    
    public void refreshTree(){
        collapseRow(0);
        getRoot().refreshProperties();
        TreeControlModel model = (TreeControlModel) getModel();
        model.fireTreeStructureChanged();
        expandRow(0);
    }
}
