package components;

import javax.swing.JTextArea;

import org.apache.log4j.*;
import org.apache.log4j.spi.*;


/**
 * @author Dave Cramer
 * @version 1.0
 */

public class TextAreaAppender extends AppenderSkeleton
{
  private JTextArea textArea;
  private Layout layout;

  private static TextAreaAppender instance  = null;

  public TextAreaAppender()
  {
    super();

    textArea = new JTextArea();
    textArea.setEditable( false );
    textArea.setAutoscrolls( true );

    layout = new SimpleLayout();
    instance = this;

  }
  public TextAreaAppender(Layout layout, String name)
  {
    super();

    this.layout = layout;
    this.name = name;

    textArea = new JTextArea();
    textArea.setEditable( false );
    textArea.setAutoscrolls( true );
    instance = this;
  }
  public void enable()
  {
    textArea.enable();
  }

  public synchronized static TextAreaAppender getInstance()
  {
    if ( instance == null )
    {
      instance = new TextAreaAppender();
    }
    return instance;
  }

  public JTextArea getTextArea()
  {
    return textArea;
  }

  public void setLayout( Layout layout )
  {
    this.layout = layout;
  }

  public void setTextArea(JTextArea textArea)
  {
    this.textArea = textArea;
//    textArea.setBackground(Color.lightGray);
  }
  public boolean requiresLayout()
  {
    return true;
  }

  protected void append(LoggingEvent event)
  {
    StringBuffer text = new StringBuffer( this.layout.format(event) );

    // Print Stacktrace
    // Quick Hack maybe there is a better/faster way?

    if( layout.ignoresThrowable() )
    {
      String[] s = event.getThrowableStrRep();
      if (s != null)
      {
        int len = s.length;
        for(int i = 0; i < len; i++) {
          text.append(s[i]);
          text.append(Layout.LINE_SEP);
        }
      }
    }
    textArea.append(text.toString());
    textArea.setCaretPosition( textArea.getDocument().getLength() );
  }

  public void close()
  {
    /**@todo Implement this org.apache.log4j.Appender abstract method*/
  }
}