/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.dataaccess.DatabaseQuerys;
import pgclibrary.dataaccess.MainConnection;

public class DatabaseQuerys_7_1
extends DatabaseQuerys {
    protected MainConnection connection = null;

    public DatabaseQuerys_7_1(MainConnection _connection) {
        this.connection = _connection;
    }

    public ResultSet getGroups(String _groupName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("SELECT GRONAME as GROUP_NAME,  GROLIST as USER_LIST FROM PG_GROUP WHERE GRONAME=?");
            prep.setString(1, _groupName);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getTableColumn(String _tableName, String _columnName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("select   ATTNAME as COLUMN_NAME,  ATTNUM as COLUMN_NUMBER,  ATTNOTNULL as COLUMN_NOTNULL,  TYPNAME as TYPE_NAME,  case when pg_attribute.attlen > 0 then pg_attribute.attlen          when pg_attribute.atttypmod > 0 then pg_attribute.atttypmod-4                else -1 end as COLUMN_SIZE,  adsrc as DEFAULT_VALUE  from pg_class, pg_type, pg_attribute left join pg_attrdef  on pg_attribute.attrelid = pg_attrdef.adrelid and pg_attribute.attnum = pg_attrdef.adnum  where pg_attribute.attrelid=pg_class.oid and pg_type.OID = ATTTYPID  AND pg_class.relname=? and pg_attribute.ATTNAME=? ");
            prep.setString(1, _tableName);
            prep.setString(2, _columnName);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public String getColumnDescription(String _tableName, String _columnName) {
        String retorno = new String();
        try {
            PreparedStatement prep = this.connection.prepareStatement("select  obj_description(pg_attribute.oid) as DESCRIPTION  from pg_attribute, pg_class  where pg_class.oid = pg_attribute.attrelid and RELNAME=? AND ATTNAME=? ");
            prep.setString(1, _tableName);
            prep.setString(2, _columnName);
            ResultSet rs = prep.executeQuery();
            if (rs != null && rs.next() && rs.getString("DESCRIPTION") != null) {
                retorno = rs.getString("DESCRIPTION");
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getAttributeType(String _name) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("select  OID, TYPNAME AS TYPE_NAME, TYPLEN AS TYPE_SIZE   from pg_type where TYPNAME = ?");
            prep.setString(1, _name);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getDatabases(String _name) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("SELECT  DATNAME as DATABASE_NAME, usename as  DATABASE_DBA,   datistemplate as DATABASE_TEMPLATE, datallowconn as DATABASE_ALLOWCONN  FROM pg_database, pg_user WHERE pg_user.usesysid = DATDBA  AND DATNAME=?");
            prep.setString(1, _name);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getUser(String _name) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("SELECT  USENAME as USER_NAME, USESYSID as USER_SYSID,  USECREATEDB as USER_DBCREATOR, VALUNTIL as USER_LIMITDATE  FROM PG_USER WHERE USENAME=?");
            prep.setString(1, _name);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getUser(long _sysID) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("SELECT  USENAME as USER_NAME, USESYSID as USER_SYSID,  USECREATEDB as USER_DBCREATOR, VALUNTIL as USER_LIMITDATE  FROM PG_USER WHERE USESYSID=?");
            prep.setLong(1, _sysID);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getIndex(String _name) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("select  RELNAME as INDEX_NAME, INDISCLUSTERED as INDEX_CLUSTER,  INDHASKEYTYPE as INDEX_HASH, INDISUNIQUE as INEDEX_UNIQUE,  INDISPRIMARY as INDEX_PRIMARY  from pg_index, pg_class  where pg_class.oid = indexrelid and RELNAME = ? ");
            prep.setString(1, _name);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getColumnNames(String _tableName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("select  ATTNAME as COLUMN_NAME  from pg_attribute, pg_class  where pg_attribute.attrelid=pg_class.OID AND ATTNUM > 0      and pg_class.relname=? ");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public String getTableDescription(String _tableName) {
        String retorno = new String();
        try {
            PreparedStatement prep = this.connection.prepareStatement("select obj_description(oid) as DESCRIPTION from pg_class where RELNAME=? ");
            prep.setString(1, _tableName);
            ResultSet rs = prep.executeQuery();
            if (rs != null && rs.next() && rs.getString("DESCRIPTION") != null) {
                retorno = rs.getString("DESCRIPTION");
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getView(String _viewName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("SELECT  USENAME as VIEW_OWNER, RELNAME as VIEW_NAME,  DEFINITION as VIEW_DEFINITION  FROM PG_VIEWS, pg_class, pg_user   where pg_class.relname = pg_views.viewName  and usesysid=RELOWNER and VIEWNAME=?");
            prep.setString(1, _viewName);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getSequence(String _sequenceName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("select  SEQUENCE_NAME, USENAME as SEQUENCE_OWNER,   LAST_VALUE, INCREMENT_BY, MAX_VALUE, MIN_VALUE,  CACHE_VALUE, IS_CYCLED, IS_CALLED from " + _sequenceName + " , pg_class, pg_user  " + " where sequence_name = relname and pg_user.usesysid = relowner");
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getTable(String _tableName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("SELECT  RELNAME as TABLE_NAME, RELPAGES as TABLE_PAGES,  USENAME as TABLE_OWNER  FROM PG_CLASS, PG_USER  WHERE pg_user.usesysid=relowner and RELNAME=?");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getIndexNames(String _tableName) {
        ResultSet retorno = null;
        try {
            PreparedStatement prep = this.connection.prepareStatement("select a.RELNAME as INDEX_NAME  from pg_index, pg_class a, pg_class b where a.oid = pg_index.indexrelid  and b.oid = pg_index.indrelid and b.relname =? ");
            prep.setString(1, _tableName);
            retorno = prep.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getViewNames() {
        ResultSet retorno = null;
        try {
            retorno = this.connection.getStatement().executeQuery("SELECT  RELNAME as VIEW_NAME FROM PG_CLASS  WHERE RELKIND='v' ORDER BY RELNAME");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getSequenceNames() {
        ResultSet retorno = null;
        try {
            retorno = this.connection.getStatement().executeQuery("SELECT  RELNAME as SEQUENCE_NAME FROM PG_CLASS  WHERE RELKIND='S' ORDER BY RELNAME");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getUserNames() {
        ResultSet retorno = null;
        try {
            retorno = this.connection.getStatement().executeQuery("SELECT  USENAME as USER_NAME FROM PG_USER ORDER BY USENAME");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getGroupNames() {
        ResultSet retorno = null;
        try {
            retorno = this.connection.getStatement().executeQuery("SELECT  GRONAME as GROUP_NAME FROM PG_GROUP  ORDER BY GRONAME");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getDatabaseNames() {
        ResultSet retorno = null;
        try {
            retorno = this.connection.getStatement().executeQuery("SELECT  DATNAME as DATABASE_NAME FROM pg_database ORDER BY DATNAME");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public ResultSet getTableNames() {
        ResultSet retorno = null;
        try {
            retorno = this.connection.getStatement().executeQuery("SELECT  RELNAME as TABLE_NAME FROM PG_CLASS  WHERE RELKIND='r' ORDER BY RELNAME");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }
}

