/*
 * TableList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package pgclibrary.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class TableList extends TreeInfo {
    
    /** Creates a new instance of TableList */
    public TableList(RootElement  source) {
        super(source);
        setIcon("/images/table.png");
    }
    
    public Object getOID() {
        return toString();
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            PreparedStatement prep = getConnection().prepareStatement("SELECT RELNAME FROM PG_CLASS WHERE RELKIND='r' ORDER BY RELNAME");
            ResultSet rs = prep.executeQuery();
            while(rs.next()){
                addProperty(new Element(this, new Table(getDatabase(), rs.getString("RELNAME"))));
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
        }
    }
    
    public String toString(){
        return "Tables";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
