/*
 * View.java
 *
 * Created on 30 de julio de 2002, 18:17
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class View extends DBObject {
    private String definition = new String();
    private Vector columns = null;
    private String description = null;
    
    public View(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    public View(DBObject owner) {
        super(owner);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP VIEW ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        return getDefinition();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the Name.
     * @param _name name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            PreparedStatement prep = getConnection().prepareStatement("SELECT * FROM PG_CLASS WHERE RELNAME=?");
            prep.setString(1, _name);
            ResultSet rs = prep.executeQuery();
            if(rs.next()){
                setName(rs.getString("RELNAME"));
                setCreator(new User(this, rs.getLong("RELOWNER")));
                
                PreparedStatement prep1 = getConnection().prepareStatement("SELECT * FROM PG_VIEWS WHERE VIEWNAME=?");
                prep1.setString(1, getName());
                ResultSet rs1 = prep1.executeQuery();
                if(rs1.next()){
                    setDefinition(rs1.getString("DEFINITION"));
                    retorno = true;
                }
                rs1.close();
                prep1.close();
                retorno = true;
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        definition = new String();
        columns = null;
        description = null;
    }
    
    public dataSource getColumnsTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        
        Vector temp = getColumns();
        for(int i=0; i<temp.size(); i++){
            TableColumn tc = (TableColumn) temp.get(i);
            
            Vector elem = new Vector();
            elem.add(String.valueOf(tc.getColumnNumber()));
            elem.add(tc.getName());
            elem.add(tc.getColumnType().getName());
            elem.add(String.valueOf(tc.getSize()));
            elem.add(Utilities.formatBoolean(tc.allowNulls()));
            elem.add(tc.getDefaultValue());
            elem.add(tc.getDescription());
            
            dsve.addElement(elem);
        }
        return dsve;
    }
    // ------ SET AND GET --------
    private void setDefinition(String _definition){
        if(_definition != null){
            definition = _definition;
        } else {
            definition = new String();
        }
    }
    private String getDefinition(){
        StringBuffer retorno = new StringBuffer();
        retorno.append(definition);
        retorno.append(";\n");
        
        retorno.append(getCommentSQL());
        for(int i = 0;i >getColumns().size(); i++){
            TableColumn tc = (TableColumn) getColumns().get(i);
            retorno.append(tc.getCommentSQL());
        }
        
        
        return definition;
    }
    
    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();
            try{
                PreparedStatement prep = getConnection().prepareStatement("select pg_attribute.* "
                    + " from pg_attribute, pg_class where pg_attribute.ATTRELID = pg_class.oid "
                    + " and pg_class.relname=? and attnum > 0 order by attnum");
                prep.setString(1, getName());
                ResultSet rs = prep.executeQuery();
                while(rs.next()){
                    columns.add(new TableColumn(this, rs.getString("ATTNAME")));
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return columns;
    }
    
    private String getCommentSQL(){
        String retorno = new String();
        if(getDescription().length() > 0){
            retorno = "COMMENT ON VIEW " + getName() 
                        + " IS '" + getDescription() + "'; \n";
        }
        return retorno;
    }
    public String getDescription(){
        if(description == null){
            try{
                PreparedStatement prep;
                
                if(getConnection().getDatabaseVersion() < 7.2){
                    prep = getConnection().prepareStatement("select obj_description(oid) as DESCRIPTION from pg_class where RELNAME=? ");
                } else {
                    prep = getConnection().prepareStatement("select obj_description(oid, relname) as DESCRIPTION from pg_class where RELNAME=? ");
                }
                prep.setString(1, getName());
                
                ResultSet rs = prep.executeQuery();
                if(rs.next()){
                    setDescription(rs.getString("DESCRIPTION"));
                } else {
                    setDescription(new String());
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return description;
    }
    public void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
    /** refresh the data from database.
     * if oid>0. Elsewere no action.
     */
    public void refresh() {
        search(getName());
    }
}

