/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.treeObjects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.Database;
import pgclibrary.objects.Sequence;
import pgclibrary.treeObjects.Element;
import pgclibrary.treeObjects.RootElement;
import pgclibrary.treeObjects.TreeInfo;

public class SequenceList
extends TreeInfo {
    public SequenceList(RootElement source) {
        super(source);
        this.setIcon("/images/sequence.png");
    }

    public void rebuildProperties() {
        this.removeAllProperties();
        try {
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT RELNAME FROM PG_CLASS WHERE RELKIND='S' ORDER BY RELNAME");
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                this.addProperty(new Element(this, new Sequence(this.getDatabase(), rs.getString("RELNAME"))));
            }
            rs.close();
            prep.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Object getOID() {
        return this.toString();
    }

    public String toString() {
        return "Sequences";
    }

    public Database getDatabase() {
        return ((RootElement)this.getOwner()).getDatabase();
    }
}

