/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.AttributeType;
import pgclibrary.objects.DBObject;

public class TableColumn
extends DBObject {
    private int col_number = 0;
    private int size = 0;
    private boolean allow_nulls = false;
    private AttributeType column_type = null;
    private String default_value = new String();
    private String description = null;

    public TableColumn(DBObject owner, long attnum) {
        super(owner);
        this.search(attnum);
    }

    public String getDeleteSQL() {
        return new String();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(30);
        retorno.append(this.getName());
        retorno.append(" ");
        if (this.getColumnType() != null) {
            retorno.append(this.getColumnType().getName().toUpperCase());
            retorno.append(" ");
            if (this.getColumnType().getSize() < 0) {
                retorno.append("(");
                retorno.append(this.getSize());
                retorno.append(") ");
            }
        }
        if (!this.allowNulls()) {
            retorno.append("NOT NULL ");
        }
        if (this.getDefaultValue() != null && this.getDefaultValue().trim().length() > 0) {
            retorno.append("DEFAULT ");
            retorno.append(this.getDefaultValue());
        }
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(long _attnum) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("select  pg_attribute.attnum, pg_attribute.attname,  case when pg_attribute.attlen > 0 then pg_attribute.attlen                  else pg_attribute.atttypmod-4 end as colsize,  not pg_attribute.attnotnull as allownull,  adsrc as DEFAULT, pg_attribute.attnelems as vector_elements,  pg_attribute.attrelid, pg_attribute.atttypid  from pg_attribute    LEFT JOIN pg_attrdef        ON (pg_attribute.attrelid = pg_attrdef.adrelid              and pg_attribute.attnum = pg_attrdef.adnum)  where pg_attribute.attrelid = ? AND pg_attribute.ATTNUM=? ");
            prep.setLong(1, this.getOwner().getOID());
            prep.setLong(2, _attnum);
            ResultSet rs = prep.executeQuery();
            if (rs != null && rs.next()) {
                this.setOID(rs.getInt("attnum"));
                this.setName(rs.getString("ATTNAME"));
                this.setColumnNumber(rs.getInt("attnum"));
                this.setSize(rs.getInt("COLSIZE"));
                this.setAllowNulls(rs.getBoolean("ALLOWNULL"));
                this.setColumnType(AttributeType.searchObject(rs.getLong("atttypid")));
                this.setDefaultValue(rs.getString("DEFAULT"));
                retorno = true;
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.col_number = 0;
        this.size = 0;
        this.allow_nulls = false;
        this.column_type = null;
        this.default_value = new String();
        this.description = null;
    }

    private void setDefaultValue(String _value) {
        this.default_value = _value == null ? new String() : _value;
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    private void setColumnNumber(int _col_number) {
        this.col_number = _col_number;
    }

    public int getColumnNumber() {
        return this.col_number;
    }

    private void setSize(int _size) {
        this.size = _size;
    }

    public int getSize() {
        if (this.size > 0) {
            return this.size;
        }
        return this.column_type.getSize();
    }

    private void setAllowNulls(boolean _allow_nulls) {
        this.allow_nulls = _allow_nulls;
    }

    public boolean allowNulls() {
        return this.allow_nulls;
    }

    public AttributeType getColumnType() {
        return this.column_type;
    }

    private void setColumnType(AttributeType _column_type) {
        this.column_type = _column_type;
    }

    public String getDescription() {
        if (this.description == null) {
            try {
                PreparedStatement prep = this.getConnection().getDatabaseVersion() < 7.2 ? this.getConnection().prepareStatement("select obj_description(oid) as DESCRIPTION from pg_attribute where attrelid = ? AND ATTNUM=? ") : this.getConnection().prepareStatement("select col_description(attrelid, ATTNUM) as DESCRIPTION from pg_attribute where attrelid = ? AND ATTNUM=? ");
                prep.setLong(1, this.getOwner().getOID());
                prep.setLong(2, this.getColumnNumber());
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.setDescription(rs.getString("DESCRIPTION"));
                } else {
                    this.setDescription(new String());
                }
                rs.close();
                prep.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public void refresh() {
        this.search(this.getColumnNumber());
    }
}

