/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import pgclibrary.objects.Database;

public class AttributeType {
    private long oid = 0L;
    private String name = new String();
    private int size = -1;
    protected static Vector instances = new Vector();

    private AttributeType() {
    }

    public boolean search(long _oid) {
        boolean retorno = false;
        try {
            PreparedStatement prep = Database.getMainConnection().prepareStatement("select OID, *  from pg_type where oid = ?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                this.oid = rs.getLong("OID");
                this.setName(rs.getString("TYPNAME"));
                this.size = rs.getInt("TYPLEN");
                retorno = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return retorno;
    }

    public long getOID() {
        return this.oid;
    }

    private void setName(String _name) {
        this.name = _name != null ? _name : new String();
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public long getSQLType() {
        switch ((int)this.oid) {
            case 16: 
            case 1560: {
                return -7L;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return 4L;
            }
            case 700: 
            case 701: 
            case 790: 
            case 1700: {
                return 8L;
            }
            case 18: 
            case 25: 
            case 1042: 
            case 1043: {
                return 1L;
            }
            case 1082: {
                return 91L;
            }
            case 1083: {
                return 92L;
            }
            case 1084: {
                return 93L;
            }
        }
        System.out.println(this.getName() + " - " + this.oid);
        return -1L * this.oid;
    }

    public static AttributeType getInstance(long oid) {
        AttributeType retorno = null;
        int i = 0;
        while (i < instances.size() && retorno == null) {
            AttributeType tmp = (AttributeType)instances.get(i);
            if (tmp.getOID() == oid) {
                retorno = tmp;
            }
            ++i;
        }
        return retorno;
    }

    public static void addInstance(AttributeType _column) {
        if (_column != null && AttributeType.getInstance(_column.getOID()) == null) {
            instances.add(_column);
        }
    }

    public static AttributeType searchObject(long oid) {
        AttributeType retorno = AttributeType.getInstance(oid);
        if (retorno == null) {
            retorno = new AttributeType();
            if (retorno.search(oid)) {
                AttributeType.addInstance(retorno);
            } else {
                System.out.println("Atribute type not found");
                retorno = null;
            }
        }
        return retorno;
    }
}

