/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.SQLExecutionFrame;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class SQLExecutionToolbar
extends JToolBar {
    JButton execute = null;
    JButton execute_all = null;
    JButton undo = null;
    JButton redo = null;
    SQLExecutionFrame frame = null;
    JButton log = null;

    public SQLExecutionToolbar(SQLExecutionFrame _frame) {
        this.frame = _frame;
        JButton open = new JButton(new ImageIcon(this.getClass().getResource("/images/fileopen.png")));
        open.setActionCommand("open_file");
        open.setToolTipText("Open file...");
        open.addActionListener(this.frame.getListener());
        this.add(open);
        JButton save = new JButton(new ImageIcon(this.getClass().getResource("/images/filesave.png")));
        save.setActionCommand("save_file");
        save.setToolTipText("Save As...");
        save.addActionListener(this.frame.getListener());
        this.add(save);
        this.addSeparator();
        this.undo = new JButton(new ImageIcon(this.getClass().getResource("/images/undo.png")));
        this.undo.setActionCommand("undo");
        this.undo.setToolTipText("Undo - [Ctrl+Z]");
        this.undo.addActionListener(this.frame.getListener());
        this.add(this.undo);
        this.redo = new JButton(new ImageIcon(this.getClass().getResource("/images/redo.png")));
        this.redo.setActionCommand("redo");
        this.redo.setToolTipText("Redo - [Ctrl+R]");
        this.redo.addActionListener(this.frame.getListener());
        this.add(this.redo);
        this.execute = new JButton(new ImageIcon(this.getClass().getResource("/images/execute.gif")));
        this.execute.setActionCommand("execute");
        this.execute.setToolTipText("Execute current command - [F5]");
        this.execute.addActionListener(this.frame.getListener());
        this.addSeparator();
        this.add(this.execute);
        this.execute_all = new JButton(new ImageIcon(this.getClass().getResource("/images/execute_all.gif")));
        this.execute_all.setActionCommand("execute_all");
        this.execute_all.setToolTipText("Execute all commands - [F4]");
        this.execute_all.addActionListener(this.frame.getListener());
        this.add(this.execute_all);
        this.addSeparator();
        this.log = new JButton(new ImageIcon(this.getClass().getResource("/images/log.png")));
        this.log.setActionCommand("log_query");
        this.log.setToolTipText("Log querys");
        this.log.addActionListener(this.frame.getListener());
        this.add(this.log);
        JButton exit = new JButton(new ImageIcon(this.getClass().getResource("/images/exit.png")));
        exit.setActionCommand("close");
        exit.setToolTipText("Exit");
        exit.addActionListener(this.frame.getListener());
        this.addSeparator();
        this.add(exit);
    }

    public void refreshValidation() {
        if (this.frame != null) {
            boolean valid = this.frame.getPrincipalFrame().getDatabase().validate();
            this.execute.setEnabled(valid);
            this.execute_all.setEnabled(valid);
            this.log.setEnabled(valid && !this.frame.isLogActive());
            this.undo.setEnabled(valid);
            this.redo.setEnabled(valid);
        }
    }
}

