/*
 * Database.java
 *
 * Created on 30 de julio de 2002, 15:49
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class Database extends DBObject {
    protected static MainConnection connection = null;
    
    private String encoding = new String();
    private String template = new String();
    private String location = new String();
    private boolean isTemplate = false;
    private boolean allowConnections = false;
    
    /** Creates a new instance of Database */
    public Database(MainConnection _connection) {
        super(null);
        setConnection(_connection);
        try{
            PreparedStatement prep = getConnection().prepareStatement("SELECT OID, * FROM pg_database WHERE DATNAME=?");
            prep.setString(1, getConnection().getDatabaseName());
            ResultSet rs = prep.executeQuery();
            if(rs.next()){
                search(rs.getLong("OID"));
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
            e.printStackTrace();
        }
    }
    
    public Database(MainConnection _connection, long oid) {
        super(null);
        setConnection(_connection);
        search(oid);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP DATABASE ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE DATABASE ");
        retorno.append(getName()).append(" ");
        
        if ((getLocation().length() > 0)
        || (getTemplate().length() > 0)
        || (getEncoding().length() > 0)){
            retorno.append("WITH ");
            if(getLocation().length() > 0){
                retorno.append("LOCATION='").append(getLocation()).append("' ");
            }
            if(getTemplate().length() > 0){
                retorno.append("TEMPLATE=").append(getTemplate()).append(" ");
            }
            if(getEncoding().length() > 0){
                retorno.append("ENCODING=").append(getEncoding()).append(" ");
            }
        }
        
        retorno.append(";\n ");
        
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the OID.
     * @param _oid OID to search.
     * @return true if the object was found
     */
    public boolean search(long _oid) {
        boolean retorno = false;
        if(validate()){
            try{
                initialize();
                
                PreparedStatement prep = getConnection().prepareStatement("SELECT OID, * FROM pg_database WHERE OID=?");
                prep.setLong(1, _oid);
                ResultSet rs = prep.executeQuery();
                if(rs.next()){
                    setOID(rs.getLong("OID"));
                    setName(rs.getString("DATNAME"));
                    setDBA(rs.getLong("DATDBA"));
                    setTemplate(rs.getBoolean("datistemplate"));
                    setAllowConnections(rs.getBoolean("datallowconn"));
                    retorno = true;
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return retorno;
    }
    
    protected void initialize() {
        super.initialize();
        isTemplate = false;
        allowConnections = false;
    }
    
    // ------------ SET AND GET  ---------
    public boolean isTemplate(){
        return isTemplate;
    }
    public void setTemplate(boolean _isTemplate){
        isTemplate = _isTemplate;
    }
    
    public boolean allowConnections(){
        return allowConnections;
    }
    public void setAllowConnections(boolean _allowConnections){
        allowConnections = _allowConnections;
    }
    
    public void setDBA(User _user){
        setCreator(_user);
    }
    public void setDBA(long _user){
        setCreator(new User(this, _user));
    }
    public User getDBA(){
        return getCreator();
    }
    
    public void setEncoding(String _encoding){
        if(_encoding != null){
            encoding = _encoding;
        } else {
            encoding = new String();
        }
    }
    public String getEncoding(){
        return encoding;
    }
    
    public void setTemplate(String _template){
        if(_template != null){
            template = _template;
        } else {
            template = new String();
        }
    }
    public String getTemplate(){
        return template;
    }
    
    public void setLocation(String _location){
        if(_location != null){
            location = _location;
        } else {
            location = new String();
        }
    }
    public String getLocation(){
        return location;
    }
    
    private static void setConnection(MainConnection _connection){
        connection = _connection;
    }
    public MainConnection getConnection(){
        return connection;
    }
    public static MainConnection getMainConnection(){
        return connection;
    }
    
    public boolean validate(){
        return connection != null;
    }
}
