/*
 * SQLExecutionToolbar.java
 *
 * Created on 19 de julio de 2002, 10:28
 */

package frames;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class SQLExecutionToolbar extends JToolBar{
    JButton execute = null;
    JButton execute_all = null;
    JButton undo = null;
    JButton redo = null;
    SQLExecutionFrame frame = null;
    JButton log = null;
    
    /** Creates a new instance of SQLExecutionToolbar */
    public SQLExecutionToolbar(SQLExecutionFrame _frame){
        frame = _frame;

        JButton open = new JButton(new ImageIcon("images/fileopen.png"));
        open.setActionCommand(SQLExecutionListener.AC_OPEN_FILE);
        open.setToolTipText("Open file...");
        open.addActionListener(frame.getListener());
        add(open);
        JButton save = new JButton(new ImageIcon("images/filesave.png"));
        save.setActionCommand(SQLExecutionListener.AC_SAVE_FILE);
        save.setToolTipText("Save As...");
        save.addActionListener(frame.getListener());
        add(save);

        
        addSeparator();
        undo = new JButton(new ImageIcon("images/undo.png"));
        undo.setActionCommand(SQLExecutionListener.AC_UNDO);
        undo.setToolTipText("Undo - [Ctrl+Z]");
        undo.addActionListener(frame.getListener());
        add(undo);
        redo = new JButton(new ImageIcon("images/redo.png"));
        redo.setActionCommand(SQLExecutionListener.AC_REDO);
        redo.setToolTipText("Redo - [Ctrl+R]");
        redo.addActionListener(frame.getListener());
        add(redo);
        
        
        execute = new JButton(new ImageIcon("images/execute.gif"));
        execute.setActionCommand(SQLExecutionListener.AC_EXECUTE);
        execute.setToolTipText("Execute current command - [F5]");
        execute.addActionListener(frame.getListener());
        addSeparator();
        add(execute);
        
        execute_all = new JButton(new ImageIcon("images/execute_all.gif"));
        execute_all.setActionCommand(SQLExecutionListener.AC_EXECUTE_ALL);
        execute_all.setToolTipText("Execute all commands - [F4]");
        execute_all.addActionListener(frame.getListener());
        add(execute_all);

        addSeparator();
        log = new JButton(new ImageIcon("images/log.png"));
        log.setActionCommand(SQLExecutionListener.AC_LOG_QUERYS);
        log.setToolTipText("Log querys");
        log.addActionListener(frame.getListener());
        add(log);
        
        JButton exit = new JButton(new ImageIcon("images/exit.png"));
        exit.setActionCommand(SQLExecutionListener.AC_CLOSE);
        exit.setToolTipText("Exit");
        exit.addActionListener(frame.getListener());
        addSeparator();
        add(exit);
    }
    
    public void  refreshValidation(){
        if(frame != null){
            boolean valid = frame.getPrincipalFrame().getDatabase().validate();
            execute.setEnabled(valid);
            execute_all.setEnabled(valid);
            log.setEnabled(valid && !frame.isLogActive());
            undo.setEnabled(valid);
            redo.setEnabled(valid);
        }
    }    
}