--
-- install_customerdb.sql
--
-- customerdb is a sample data base for use with pfm version 1.1.1
-- To install it, create a new database, then run this SQL script
-- on that database.
--
-- Note: This SQL script also installs the pfm_* tables. Do not run
--       it on a database that already contains the pfm_* tables.

--
-- TOC entry 11 (OID 32593)
-- Name: customer; Type: TABLE; Schema: public; Owner: wim
--

--
-- TOC entry 16 (OID 40869)
-- Name: pfm_version; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_version (
    seqnr serial NOT NULL,
    "version" text,
    date text,
    "comment" text
);

INSERT INTO pfm_version (seqnr, "version", "date", "comment")
VALUES (DEFAULT, '1.1.1', CURRENT_DATE, 'install_customerdb.sql');



CREATE TABLE customer (
    id serial NOT NULL,
    name text,
    street text,
    post_code text,
    town text,
    country text,
    telephone text,
    e_mail text
);


--
-- TOC entry 12 (OID 32599)
-- Name: product; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE product (
    id serial NOT NULL,
    name text,
    description text,
    nr_in_stock integer,
    price numeric(8,2)
);


--
-- TOC entry 13 (OID 32605)
-- Name: order; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE "order" (
    invoice integer,
    product integer,
    nr integer
);


--
-- TOC entry 14 (OID 32607)
-- Name: invoice; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE invoice (
    id serial NOT NULL,
    customer integer,
    date date
);


--
-- TOC entry 15 (OID 32610)
-- Name: pfm_attribute; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_attribute (
    attribute text,
    typeofattrib text,
    typeofget text,
    sqlselect text,
    nr integer,
    form text,
    valuelist text
);


--
-- TOC entry 16 (OID 32615)
-- Name: pfm_form; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_form (
    name text NOT NULL,
    tablename text,
    showform boolean DEFAULT true,
    "view" boolean DEFAULT false,
    sqlselect text,
    sqlfrom text,
    groupby text,
    help text
);


--
-- TOC entry 17 (OID 32622)
-- Name: pfm_link; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_link (
    linkname text,
    sqlwhere text,
    orderby text,
    displayattrib text,
    fromform text,
    toform text
);


--
-- TOC entry 18 (OID 32627)
-- Name: pfm_report; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_report (
    name text NOT NULL,
    description text,
    sqlselect text,
    sqlwhere text,
    orderby text
);


--
-- TOC entry 19 (OID 32632)
-- Name: pfm_section; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_section (
    report text,
    "level" integer,
    fieldlist text,
    layout text
);


--
-- TOC entry 20 (OID 32637)
-- Name: pfm_value; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_value (
    value text,
    description text,
    valuelist text
);


--
-- TOC entry 21 (OID 32642)
-- Name: pfm_value_list; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_value_list (
    name text NOT NULL
);




--
-- Data for TOC entry 34 (OID 32593)
-- Name: customer; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY customer FROM stdin;
3	Frans Van Langenacker	Transvaalstraat 34	2030	Antwerpen	Belgi	03 326 25 60	fvla@vt4.be
2	Nelly Peeters	Grote Markt 24	7023	Sint-Niklaas	Belgi	03 911 22 45	n.peeters@pandora.be
9	Staf De Wilde	Lange Lepelstraat 45	2000	Antwerpen	Belgi	03 233 62 60	
5	Jacky Verelst	Kesselsebaan 45	2520	Emblem	Belgi	03 234 56 32	jacky.verelst@skynet.be
10	Dirk Versmissen	Draaiboom 4	2260	Wommelgem	Belgi	03 465 32 67	dirkv@vt4.be
6	Nancy Verdonck	Azalealaan 23	9520	Lokeren	Belgi	09 223 45 67	n.vcb@pi.be
8	Nestor Stassyns	Calle Salinas 343	2000	Buenos Aires	Argentina		nestor.stassyns@argentel.ag
\.


--
-- Data for TOC entry 35 (OID 32599)
-- Name: product; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY product FROM stdin;
2	SuSE 8.2 professional	Linux distribution	12	81.50
3	Windows XP - new PC	Microsoft windows XP for new PC	12	99.50
4	Windows XP upgrade	Microsoft windows not bound to a particular PC	3	399.00
5	Tcl/Tk	Tool Command Language and Toolkit	12	12.30
6	postgreSQL	Relational database server	23	15.60
7	Open Office	CD met Office pakekt voor Windows en Linux	12	10.00
1	SuSE 8.2 personal	Linux distribution	12	23.20
\.


--
-- Data for TOC entry 36 (OID 32605)
-- Name: order; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY "order" FROM stdin;
6	6	2
6	5	2
11	5	12
11	1	12
1	5	3
12	2	1
11	6	5
15	7	3
15	6	2
15	3	4
11	3	3
1	7	2
16	5	2
1	1	1
1	6	4
\.


--
-- Data for TOC entry 37 (OID 32607)
-- Name: invoice; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY invoice FROM stdin;
11	8	2003-12-17
12	8	2003-12-18
6	6	2003-12-10
15	8	2004-01-13
16	10	2004-01-14
1	6	2003-11-07
\.


--
-- Data for TOC entry 38 (OID 32610)
-- Name: pfm_attribute; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_attribute FROM stdin;
layout	taQuoted	tgList		3	pfm_section	layout
linkname	taQuoted	tgDirect		1	pfm_link	none
value	taQuoted	tgDirect	\N	2	pfm_value	none
sqlwhere	taQuoted	tgDirect		4	pfm_link	none
orderby	taQuoted	tgDirect		5	pfm_link	none
displayattrib	taQuoted	tgDirect		6	pfm_link	none
description	taQuoted	tgDirect		3	pfm_value	none
name	taQuoted	tgDirect		1	pfm_report	none
description	taQuoted	tgDirect		2	pfm_report	none
report	taQuoted	tgLink	select name, description from pfm_report order by name	1	pfm_section	none
level	taNotQuoted	tgDirect		2	pfm_section	none
fieldlist	taQuoted	tgDirect		4	pfm_section	none
name	taQuoted	tgDirect		1	pfm_form	none
form	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	1	pfm_attribute	none
fromform	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	2	pfm_link	none
toform	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	3	pfm_link	none
valuelist	taQuoted	tgLink	SELECT name FROM pfm_value_list ORDER BY name	1	pfm_value	none
name	taQuoted	tgDirect		1	pfm_value_list	none
id	taNotQuoted	tgDirect		1	customer	none
name	taQuoted	tgDirect		2	customer	none
street	taQuoted	tgDirect		3	customer	none
post_code	taQuoted	tgDirect		4	customer	none
town	taQuoted	tgDirect		5	customer	none
country	taQuoted	tgDirect		6	customer	none
telephone	taQuoted	tgDirect		7	customer	none
e_mail	taQuoted	tgDirect		8	customer	none
id	taNotQuoted	tgDirect		1	invoice	none
customer	taNotQuoted	tgLink	SELECT id, name FROM customer ORDER BY name	2	invoice	none
date	taQuoted	tgDirect		3	invoice	none
invoice	taNotQuoted	tgLink	SELECT i.id, i."date", c.name FROM invoice i, customer c WHERE (c.id = i.customer) ORDER BY i."date"	1	order	none
id	taNotQuoted	tgDirect		1	product	none
name	taQuoted	tgDirect		2	product	none
description	taQuoted	tgDirect		3	product	none
nr_in_stock	taNotQuoted	tgDirect		4	product	none
price	taNotQuoted	tgDirect		5	product	none
sqlselect	taQuoted	tgDirect		3	pfm_form	none
sqlfrom	taQuoted	tgDirect		4	pfm_form	none
attribute	taQuoted	tgDirect		6	pfm_attribute	none
typeofattrib	taQuoted	tgList		7	pfm_attribute	typeofattribute
typeofget	taQuoted	tgList	\N	8	pfm_attribute	typeofget
sqlselect	taQuoted	tgDirect		9	pfm_attribute	none
valuelist	taQuoted	tgLink	SELECT name FROM pfm_value_list ORDER BY name	10	pfm_attribute	none
nr	taNotQuoted	tgDirect		11	pfm_attribute	none
cust_name	taQuoted	tgReadOnly		4	invoice	none
product	taNotQuoted	tgLink	SELECT id, name FROM product ORDER BY name	4	order	none
prod_name	taNotQuoted	tgReadOnly		5	order	none
nr	taNotQuoted	tgDirect		6	order	none
date	taNotQuoted	tgReadOnly		2	order	none
customer	taNotQuoted	tgReadOnly		3	order	none
unit_price	taNotQuoted	tgReadOnly		7	order	none
total_price	taNotQuoted	tgReadOnly		8	order	none
invoice_total	taNotQuoted	tgReadOnly		5	invoice	none
showform	taQuoted	tgList		6	pfm_form	boolean
view	taQuoted	tgList		7	pfm_form	boolean
help	taQuoted	tgDirect		8	pfm_form	none
sqlselect	taQuoted	tgDirect		3	pfm_report	none
tablename	taQuoted	tgDirect		2	pfm_form	none
groupby	taQuoted	tgDirect		5	pfm_form	none
\.


--
-- Data for TOC entry 39 (OID 32615)
-- Name: pfm_form; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_form FROM stdin;
product	product	t	f	oid, id, name, description, nr_in_stock, price	product	\N	\N
pfm_value	pfm_value	f	f	oid, value, description, valuelist	pfm_value	\N	The table "pfm_value" contains all the values of the lists defined in\npfm_value_list.\n\nIt has the following attributes:\n\n    - valuelist : the name of the valuelist to which this value belongs\n\n    - value : a character string;\n\n    - description : a description of the value.\n
pfm_value_list	pfm_value_list	f	f	oid, name	pfm_value_list	\N	The table "pfm_value_list" contains all the value lists of all the forms.\n\nIts only attribute is\n\n    - name : a name uniquely identifying the value list.\n
customer	customer	t	f	oid, id, name, street, post_code, town, country, telephone, e_mail	customer	\N	When adding a new customer, just type "=" for the id. PostgreSQL then\ngenerates a new, unique id.
pfm_attribute	pfm_attribute	f	f	oid, attribute, typeofattrib, typeofget, sqlselect, nr, form, valuelist	pfm_attribute	\N	The table "pfm_attribute" defines all the properties of form attributes.\n\nIt has the following attributes:\n\n    - form : the "name" of the form to which the attribute\n      belongs;\n\n    - attribute : the name of the attribute; this must be equal\n      to the name of the corresponding attribute of the form's SQL\n      SELECT statement;\n\n    - typeofattrib : the type of attribute:\n\n        o taQuoted: the value provided by the user is put\n             between single quotes when it is transferred to SQL\n             UPDATE or INSERT statements;\n            \n        o taNotQuoted: the value provided by the user is not\n             quoted when it is transferred to SQL UPDATE or INSERT\n             statements.\n\n          Hint: In general, all attribute values must be quoted, exept\n                the values or expressions for numeric attributes.\n\n    - typeofget: defines how the user provides a value for the\n      attribute; possible values are:\n\n          o tgDirect: the user types the value directly;\n\n          o tgExpression: the user types an expression which is first\n            evaluated before it is passed to SQL UPDATE or INSERT;\n\n            Note: Even with tgDirect it is possible to enter an\n                  expression as new value for an attribute, but then\n                  the expression is evaluated by postgresql whereas\n                  with tgExpression, the expression is first evaluated\n                  by Tcl before the SQL statement is sent to\n                  postgresql.\n\n          o tgList: the user selects a value by means of a list box\n            containing a list of values defined in table "pfm_value";\n\n          o tgLink: the user selects a value by means of a list box\n            containing a list of values which is the result from a\n            query on another table.\n\n          o tgReadOnly: this attribute cannot be modified by\n            the user.\n\n            Note: All calculated attributes and all attributes from\n                  tables other than the form's main table should be\n                  declared 'read-only'. If this rule is not observed,\n                  the Add and Update operations on this form will fail.\n\n    - sqlselect: the SQL SELECT statement which is used to fill the\n      list box with possible values for the attribute (only meaningful\n      if typeofget = tgLink).\n\n      Note :\n\n         o The sqlselect may return more than 1 attribute. If so, all\n           the attributes are displayed in the list-box, but only the\n           first one is used for updating the attribute.\n\n    - valuelist : the "name" of the value list defined in table\n      "pfm_value_list" (only meaningful if typeofget = tgList);\n\n    - nr: a number which determines the order in which attributes are\n      displayed on the form;\n
order	order	t	f	"order".oid, "order".invoice, "order".product, p.name AS prod_name, "order".nr, p.price AS unit_price, ("order".nr * p.price) AS total_price, i."date", c.name AS customer	"order"\n    LEFT OUTER JOIN invoice i ON ("order".invoice = i.id)\n    LEFT OUTER JOIN customer c ON (i.customer = c.id)\n    LEFT OUTER JOIN product p ON ("order".product = p.id)	\N	The attributes that can be modified are:\n\n    - invoice: the id of the invoice to which the order belongs.\n      You can select one from the list of invoices.\n\n    - product: you can select one from the list of products\n      in the data base.\n\n    - nr: the number of products identified by 'product' that the\n      customer orders for this invoice.
pfm_link	pfm_link	f	f	oid, linkname, sqlwhere, orderby, displayattrib, fromform, toform	pfm_link	\N	A link is a navigation tool which allows you to follow a "one-to-many"\nor "many-to-one" relationship from one form to another.\n\nEvery link is stored as a record in the pfm_link table, which has the\nfollowing attributes:\n\n    - linkname : the name of the link, which is displayed on\n      a link button on the "fromform";\n\n    - fromform : the name of the form from which the link\n      originates;\n\n    - toform : the name of the form to which the link leads;\n\n    - sqlwhere : the "WHERE"-clause which is used to open the\n      "toform" and in which the value of an attribute of the\n      "fromform" may be represented by $(attrib-x), where\n      'attrib-x' is the name of the attribute;\n\n    - orderby : an 'order by' clause which determines the order of the\n      records in the 'toform';\n\n    - displayattrib : a space separated list of\n      attributes of the 'fromform', the value of which is displayed on\n      the 'toform' to remind the user from which record the link\n      originated.\n\nNote: Postgres Forms does not provide any checks to safeguard\n      the referential integrity of the data base in case of updates or\n      deletions. However, postgreSQL provides these functions as\n      'foreign key' table constraints (see postgreSQL documentation).
pfm_report	pfm_report	f	f	oid, name, description, sqlselect	pfm_report	\N	The table pfm_report defines all the reports for the current data\nbase.\n\npfm_report has the following attributes:\n\n    - name: the name of the report. This is the name that\n      appears in the selection list of the "Run Report" function.\n\n    - description: free text describing the purpose of the\n      report in more detail.\n\n    - sqlselect: an SQL SELECT statement that generates the\n      data for the report.\n\nThe sqlselect may contain one or more parameters for which a\nvalue is requested at "Run report" time. A parameter in the sqlwhere\nmust be formatted as $(parameter_name).\n\nExample:\n\nsqlselect: \n\nSELECT * FROM report_view\nWHERE (customer='$(customer_name)') AND ("date" >= '$(begin_date)')\n\nWhen the report is run, the user is prompted to enter values for the\nparameters "customer_name" and "begin_date". Then the report data are\ngenerated by executing the sqlselect statement in which the\n$(customer_name) and $(begin_date) are replaced with the values\nentered by the user
pfm_section	pfm_section	f	f	oid, report, level, fieldlist, layout	pfm_section	\N	The table pfm_section contains all the sections of the reports defined\nin pfm_report. A report must have one section at least.\n\nThe table pfm_section has the following attributes:\n\n    - report: the name of the report to which the section belongs\n\n    - level: a number 1, 2, 3, 4, ... which uniquely identifies a\n      section within a report and which also defines an order of the\n      sections.\n\n    - layout: can be "row", "column" or "table".\n\n    - fieldlist: a space separated list of field specifiers,\n      one for each field to be printed in this section of the report\n      (see below for details).\n\nThe fieldlist must be formatted as follows:\n\n{attribute_1 label_1 alignment_1} {attribute_2 label_2 alignment_2}...\n                                        {attribute_N label_N alignment_N}\n\nwhere :\n\n    - attribute_i is the name of the view attribute that has to be\n      printed in the i-th field of this section;\n\n    - label_i is a string which has to be used as label for printing\n      the i-th field of this section; if it consists of more than 1\n      word, it must be delimited by double quotes (" .... ");\n\n    - alignment_i is optional; if present, it is either l or r,\n      indicating whether this field should be left or right aligned.\n\n      Notes :\n\n          o The alignment is optional. If it is left out, left\n            alignment is assumed by default.\n\n          o The alignment only influences the table layout. Column and\n            row layouts are unaffected by the alignment indicator.\n\n          o Multi-line fields, i.e. fields containing more than one\n            line of text are only formatted properly in a column layout.\n\nAll sections of a report, except the last one (i.e. the one with the\nhighest level), are "group level sections".\n\nWhen the report is being generated, first the records resulting from\nexecuting the report's SQL SELECT statement are stored internally.\n\nThen the data of the first record are printed, first the fields of the\nlevel 1 section, then the fields of the level 2 section, etc. up to\nthe fields of the last section.\n\nWhen the next records are being printed, the "group level sections"\nare only printed when at least one of the fields belonging to that\nsection has a value different from the corresponding field of the\npreviously printed section of the same level.\n\nOnly the highest level section (which is not a "group level section")\nis printed for all records.\n\nFor every section, the layout can be defined as:\n\n    - row: the section's field labels and field values are\n      printed in one row in a format: label_1 : value_1; label_2 :\n      value_2; ... etc.\n\n    - column: the section's field labels are printed in a first\n      column, the section's field values are printed in a second column.\n\n    - table: the section's values are printed in a table with a\n      column per field and a row per record, the section's field\n      labels are used as column headers for the table.\n
invoice	invoice	t	f	invoice.oid, invoice.id, invoice.customer, invoice."date", customer.name AS cust_name, SUM(p.price * o.nr) AS invoice_total	invoice\n    LEFT OUTER JOIN customer ON (invoice.customer = customer.id)\n    LEFT OUTER JOIN "order" o ON (invoice.id = o.invoice)\n    LEFT OUTER JOIN product p ON (o.product = p.id)	invoice.oid, invoice.id, invoice.customer, invoice."date", customer.name	The attributes of the form "invoice" are:\n\n    - id : an integer that uniquely identifies the invoice. Normally,\n      it is not necessary to modify it. When adding a new invoice,\n      just type "=" to let postgreSQL automaticaly generate a new\n      value for id.\n\n    - customer: the id of the invoice's customer. You can select one\n      from the list of customers in the database.\n\n    - date: the invoice's date in the form: yyyy-mm-dd.\n\n    - cust_name: the name of the invoice's customer. You cannot modify\n      it directly. If the attribute 'customer' is modified, the attribute\n      'cust_name' is update accordingly.\n\n    - invoice_total: the sum of the price of the invoice's orders. 
pfm_form	pfm_form	f	f	oid, name, tablename, sqlselect, sqlfrom, groupby, showform, "view", help	pfm_form	\N	A form has a one-to-one relation with just 1 database table. Only the\ndata of that table can be administered by means of the form. This\ntable is henceforth referred to as "the form's main table".\n\nHowever, the form also has a one-to-one relationship with just one SQL\nSELECT statement, which generates the data that are displayed on the\nform.\n\nIn the simplest case the SQL SELECT statement is just:\n\n    SELECT oid, <attributes of main table> FROM <main table>\n\nIn that case, the data which can be administered and the data which\nare displayed on the form are the same.\n\nIn more complex cases, the <main table> can be JOINED with other\ntables, which makes it possible to display data of other related\ntables as well. These data cannot be modified by means of the form.\n\nThe table "pfm_form" has the following attributes:\n\n    - name : the name of the form (usually equal to the name of\n      the form's table);\n\n    - tablename : the name of the form's main table;\n\n    - sqlselect : the attribute list of the form's SQL SELECT\n      statement, not including the word 'SELECT';\n\n    - sqlfrom : the FROM clause of the form's SQL SELECT\n      statement, not including the word 'FROM';\n\n    - groupby : an optional 'GROUP BY' clause, not\n      including the words 'GROUP BY';\n\n    - view : a boolean indicating whether or not the\n      "tablename" is a view;\n\n    - showform : a boolean indicating whether the form is shown\n      in "normal mode" (showform = 'true') or in "design mode"\n      (showform = 'false'). Typically, showform is set 'true' for user\n      defined forms and 'false' for the predefined pfm_* forms.\n\n    - help : a text which is displayed when the user presses\n      the [Help] key on the form.\n\nThe form's main table is defined by tablename. Only the data of\nthat table can be administered by using the form.\n\nAll the data generated by the form's SQL SELECT statement can be\ndisplayed on the form. The SQL SELECT statement is defined by:\n\n    - the sqlselect, sqlfrom and groupby attributes of pfm_form; and\n\n    - the optional WHERE and ORDER BY clauses provided by the user\n      when opening the form.\n\nNote: The WHERE clause provided by the user when opening the form, is\n      automatically converted to a HAVING clause, if there is a GROUP\n      BY clause.\n\nThe following rules should be observed when filling out sqlselect and\nsqlfrom:\n\n    1. The form's main table must appear in 'sqlfrom', and must not be\n       aliased. Similarly, the main table's attributes appearing in\n       'sqlselect' must not be aliased. The other tables appearing in\n       the 'sqlfrom' may be aliased.\n\n    2. The fields appearing in 'sqlselect' must have a unique, simple\n       name without the need to precede them with a tablename. So,\n       calculated fields must be given a name by aliasing and\n       attributes of tables other than the main table may need to be\n       aliased in order to have a unique, simple name.\n\n    3. If the form's main table is not a view, the 'sqlselect' must\n       contain the 'oid' of the main table. If the form's main table\n       is a view, the 'sqlselect' must not contain the 'oid' of the\n       main table.\n\n       Note: The 'oid' is the 'object identifier'. It uniquely\n             identifies a row in a table. All tables (not views)\n             implicitly have an oid in postgreSQL. Postgres Forms\n             needs it for identifying a row when issuing an SQL UPDATE\n             or DELETE FROM command. There is no need to display this\n             attribute on the form, i.e. it is not necessary to define\n             it as an attribute in pfm_attribute.\n\n    4. The 'sqlfrom' is either just the name of the form's main table,\n       or it is a JOIN clause in which 1 of the tables is the form's\n       main table. Several join clauses can be nested in order to\n       involve more than 2 tables. See examples below.\n\n\nExample 1: the SQL SELECT for the person form of the addressbook database\n\n\ntablename:\n    person\n\nsqlselect:\n    oid, id, christian_name, name, street, town, "ZIPcode",\n    country, category, description\n\nsqlfrom:\n    person\n\ngroupby:\n    -\n\n\nExample 2: the SQL SELECT for the memberlist form of the addressbook database\n\n\ntablename:\n    memberlist\n\nsqlselect:\n    memberlist.oid, memberlist."group", memberlist.person,\n    p.christian_name, p.name\n\nsqlfrom:\n    memberlist LEFT OUTER JOIN person p ON (p.id = memberlist.person)\n\ngroupby:\n    -
\.


--
-- Data for TOC entry 40 (OID 32622)
-- Name: pfm_link; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_link FROM stdin;
Report	name='$(report)'		level	pfm_section	pfm_report
Sections	report='$(name)'	level	name	pfm_report	pfm_section
Attributes	form='$(name)'	nr	name	pfm_form	pfm_attribute
incoming links	toform='$(name)'	fromform	name	pfm_form	pfm_link
outgoing links	fromform='$(name)'	toform	name	pfm_form	pfm_link
Where used?	valuelist='$(name)'		name	pfm_value_list	pfm_attribute
Values	valuelist='$(name)'	value	name	pfm_value_list	pfm_value
Value list	name='$(valuelist)'		attribute	pfm_attribute	pfm_value_list
from Form	name='$(fromform)'		linkname	pfm_link	pfm_form
to Form	name='$(toform)'		linkname	pfm_link	pfm_form
Valuelist	name='$(valuelist)'		value	pfm_value	pfm_value_list
Invoices	customer=$(id)	"date"	name	customer	invoice
Customer	id=$(customer)		date	invoice	customer
Orders	invoice=$(id)		id	invoice	order
Product	id=$(product)		invoice	order	product
Orders	product=$(id)	invoice	name	product	order
Invoice	invoice.id=$(invoice)			order	invoice
Form	name='$(form)'		attribute	pfm_attribute	pfm_form
\.


--
-- Data for TOC entry 41 (OID 32627)
-- Name: pfm_report; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_report FROM stdin;
Invoices	Show invoices for a particular customer since a certain date	SELECT c.id AS cust_id, c.name AS customer, c.street, c.post_code, c.town,\n       c.country, c.telephone, c.e_mail, i.id AS invoice, i.date,\n       o.nr, o.product AS prod_nr, p.name AS product, p.price,\n       (o.nr::numeric * p.price)::numeric(9,2) AS total\nFROM invoice i\n      LEFT JOIN customer c ON (c.id = i.customer)\n      LEFT JOIN "order" o ON (i.id = o.invoice)\n      LEFT JOIN product p ON (o.product = p.id)\nWHERE (c.name ='$(customer_name)') AND ("date" >= '$(begin_date)')\nORDER BY c.id, i.date\n	(customer='$(customer_name)') AND ("date" >= '$(begin_date)')	
\.


--
-- Data for TOC entry 42 (OID 32632)
-- Name: pfm_section; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_section FROM stdin;
Invoices	2	{invoice "Invoice nr." r} {date "Date" l} 	row
Invoices	3	{nr "nr. of units" r} {prod_nr "Prod. nr" r} {product "Product" l} {price "unit price" r} {total "Total price" r}	table
Invoices	1	{cust_id "Customer Id"} {customer Name} {street Address} {post_code ZIP} {town Town} {country Country} {telephone Tel.} {e_mail E-mail}	column
\.


--
-- Data for TOC entry 43 (OID 32637)
-- Name: pfm_value; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_value FROM stdin;
taQuoted	Value must be enclosed in ' ' for SQL.	typeofattribute
taNotQuoted	Value must not be enclosed in ' ' for SQL.	typeofattribute
tgDirect	Value directly typed by user.	typeofget
tgExpression	Value may be given as an expression.	typeofget
tgList	Value comes from a valuelist.	typeofget
tgLink	Value comes from 'sqlselect'.	typeofget
t	TRUE	boolean
f	FALSE	boolean
column	A column for the labels, a second column for the corresponding values	layout
table	A table with the labels as table header	layout
row	Labels and values on 1 row	layout
tgReadOnly	Value never to be entered by the user	typeofget
\.


--
-- Data for TOC entry 44 (OID 32642)
-- Name: pfm_value_list; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_value_list FROM stdin;
typeofattribute
typeofget
boolean
layout
none
\.


--
-- TOC entry 26 (OID 32845)
-- Name: customer_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT customer_pkey PRIMARY KEY (id);


--
-- TOC entry 27 (OID 32847)
-- Name: product_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY product
    ADD CONSTRAINT product_pkey PRIMARY KEY (id);


--
-- TOC entry 28 (OID 32849)
-- Name: invoice_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT invoice_pkey PRIMARY KEY (id);


--
-- TOC entry 30 (OID 32851)
-- Name: pfm_report_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_report
    ADD CONSTRAINT pfm_report_pkey PRIMARY KEY (name);


--
-- TOC entry 31 (OID 32857)
-- Name: pfm_value_list_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value_list
    ADD CONSTRAINT pfm_value_list_pkey PRIMARY KEY (name);


--
-- TOC entry 29 (OID 32863)
-- Name: pfm_form_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_form
    ADD CONSTRAINT pfm_form_pkey PRIMARY KEY (name);


--
-- TOC entry 33 (OID 47687)
-- Name: pfm_version_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_version
    ADD CONSTRAINT pfm_version_pkey PRIMARY KEY (seqnr);


--
-- TOC entry 54 (OID 32853)
-- Name: ref_sections; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_section
    ADD CONSTRAINT ref_sections FOREIGN KEY (report) REFERENCES pfm_report(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 55 (OID 32859)
-- Name: ref_list; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value
    ADD CONSTRAINT ref_list FOREIGN KEY (valuelist) REFERENCES pfm_value_list(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 50 (OID 32865)
-- Name: ref_form; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT ref_form FOREIGN KEY (form) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 51 (OID 32869)
-- Name: ref_value_list; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT ref_value_list FOREIGN KEY (valuelist) REFERENCES pfm_value_list(name) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 52 (OID 32873)
-- Name: ref_fromform; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT ref_fromform FOREIGN KEY (fromform) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 53 (OID 32877)
-- Name: ref_toform; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT ref_toform FOREIGN KEY (toform) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 49 (OID 32883)
-- Name: ref_customer; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT ref_customer FOREIGN KEY (customer) REFERENCES customer(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 47 (OID 32887)
-- Name: ref_invoice; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT ref_invoice FOREIGN KEY (invoice) REFERENCES invoice(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 48 (OID 32891)
-- Name: ref_product; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT ref_product FOREIGN KEY (product) REFERENCES product(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 6 (OID 32657)
-- Name: customer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT setval('customer_id_seq', 15, true);

--
-- TOC entry 8 (OID 32667)
-- Name: invoice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT setval('invoice_id_seq', 16, true);


--
-- TOC entry 10 (OID 32669)
-- Name: product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT setval('product_id_seq', 7, true);


