################################################################################
##$Namespace: math
##$Version: 1.0.0
##$Author: Michael E Allen
##$Copyright: Copyright(C)2001 Michael E Allen
##$License: GNU General Public License
##$Create Date: April 23, 2001
##$Description: Provides components for math functions
##$Bugs: 
##+	None
##$To Do: 
##+	Nothing
##$Changes:
##+	None
##$Disclaimer:
##+	This program is free software; you can redistribute it and/or modify
##+	it under the terms of the GNU General Public License as published by
##+	the Free Software Foundation; either version 2 of the License, or
##+	(at your option) any later version.
##+	This program is distributed in the hope that it will be useful,
##+	but WITHOUT ANY WARRANTY; without even the implied warranty of
##+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##+	GNU General Public License for more details.
##+	
##+	You should have received a copy of the GNU General Public License
##+	along with this program; if not, write to the Free Software
##+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
################################################################################
namespace eval math {
	variable PI 3.14159265358979323846
	variable E  2.7182818284590452354
	variable LOG2E 1.4426950408889634074
	variable LOG10E 0.43429448190325182765
	variable LN2 0.69314718055994530942 
	variable LN10 2.30258509299404568402
	variable PI_2 1.57079632679489661923
	variable PI_4 0.78539816339744830962
	variable 1_PI 0.31830988618379067154
	variable 2_PI 0.63661977236758134308
	variable SQRTPI 1.77245385090551602729
	variable 2_SQRTPI 1.12837916709551257390
	variable SQRT2 1.41421356237309504880
	variable SQRT3 1.73205080756887729352
	variable SQRT1_2 0.70710678118654752440
	variable LNPI 1.14472988584940017414
	variable EULER 0.57721566490153286061

	proc Abs {pValue} {
		return [expr abs($pValue)]
	}
	
	proc ACos {pValue} {
		return [expr acos($pValue)]
	}
	
	proc ASin {pValue} {
		return [expr asin($pValue)]
	}
	
	proc ATan {pValue} {
		return [expr atan($pValue)]
	}
	
	proc Max {pValue args} {
		set lMax $pValue
	
		foreach lValue $args {
			if {($lValue > $lMax)} {
				set lMax $lValue
			}
		}
	
		return $lMax
	}


	proc Min {pValue args} {
		set lMin $pValue
		
		foreach lValue $args {
			if {($lValue < $lMin)} {
				set lMin $lValue
			}
		}
	
		return $lMin
	}
	
	proc Mean {pValue args} {
		set lSum $pValue
	
		set lArgc [expr {[llength $args] + 1}]
	
		foreach lValue $args {
			set lSum [expr {$lSum + $lValue}]
		}
	
		return [expr {double($lSum) / $lArgc }]
	}
	
	proc Product {pValue args} {
		set lProduct $pValue
		
		foreach lValue $args {
			set lProduct [expr {$lProduct * $lValue}]
		}
	
		return $lProduct
	}
	
	proc Sum {pValue args} {
		set lSum $pValue
	
		foreach lValue $args {
			set lSum [expr {$lSum + $lValue}]
		}
	
		return $lSum
	}
}
