#include <iostream>
#include <string>

#include <pqxx/connection.h>
#include <pqxx/cursor.h>
#include <pqxx/transaction.h>
#include <pqxx/result.h>

using namespace std;
using namespace pqxx;


void DumpRows(const Result &R)
{
  for (Result::const_iterator i = R.begin(); i != R.end(); ++i)
    cout << "\t" << i[0].c_str() << "\t" << i[1].c_str() << endl;
  cout << endl;
}



int main()
{
  int Rows;
  Result R;

  try
  {
    Connection C("");
    Transaction T(C, "sample2");

    // Count rows; converts field from query to int
    R = T.Exec("SELECT count(*) FROM events");
    R.at(0).at(0).to(Rows);
    cout << "Table contains " << Rows << " rows." << endl;

    // Create cursor, intended to read 3 rows at a time
    Cursor Cur(T, "SELECT * FROM events ORDER BY year", "tablecur", 3);

    // Read batch of 3 rows into Result
    Cur >> R;
    DumpRows(R);

    // Read arbitrary number of rows
    R = Cur.Fetch(2);
    DumpRows(R);

    // Now let's read the same rows backwards...
 
    // Move cursor 1 step forward to make subsequent backwards fetch include
    // current row
    Cur += 1;

    // Set different default batch size for cursor
    Cur.SetCount(Cursor::BACKWARD_ALL());

    Cur >> R;
    DumpRows(R);
  }
  catch (const exception &e)
  {
    cerr << "Exception: " << e.what() << endl;
    return 1;
  }
  return 0;
}

