/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.helpers.QuietWriter;

public class FileAppender
extends WriterAppender {
    public static final String FILE_OPTION = "File";
    public static final String APPEND_OPTION = "Append";
    protected boolean fileAppend = true;
    protected String fileName = null;
    protected boolean qwIsOurs = false;

    public FileAppender() {
    }

    public FileAppender(Layout layout, OutputStream os) {
        super(layout, os);
    }

    public FileAppender(Layout layout, Writer writer) {
        super(layout, writer);
    }

    public FileAppender(Layout layout, String filename, boolean append) throws IOException {
        this.layout = layout;
        this.setFile(filename, append);
    }

    public FileAppender(Layout layout, String filename) throws IOException {
        this(layout, filename, true);
    }

    public void setFile(String file) {
        String val = file.trim();
        if (val.equalsIgnoreCase("System.out")) {
            this.setWriter(new OutputStreamWriter(System.out));
        } else if (val.equalsIgnoreCase("System.err")) {
            this.setWriter(new OutputStreamWriter(System.err));
        } else {
            this.fileName = val;
        }
    }

    public boolean getAppend() {
        return this.fileAppend;
    }

    public String getFile() {
        return this.fileName;
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{FILE_OPTION, APPEND_OPTION});
    }

    public void setAppend(boolean flag) {
        this.fileAppend = flag;
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend);
            }
            catch (IOException e) {
                this.errorHandler.error("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.", e, 4);
            }
        } else {
            LogLog.warn("File option not set for appender [" + this.name + "].");
            LogLog.warn("Are you using FileAppender instead of ConsoleAppender?");
        }
    }

    protected void closeFile() {
        if (this.qw != null && this.qwIsOurs) {
            try {
                this.qw.close();
            }
            catch (IOException e) {
                LogLog.error("Could not close " + this.qw, e);
            }
        }
    }

    public synchronized void setFile(String fileName, boolean append) throws IOException {
        this.reset();
        this.setQWForFiles(new FileWriter(fileName, append));
        this.fileName = fileName;
        this.fileAppend = append;
        this.qwIsOurs = true;
        this.writeHeader();
    }

    public void setOption(String key, String value) {
        if (value == null) {
            return;
        }
        super.setOption(key, value);
        if (key.equalsIgnoreCase(FILE_OPTION)) {
            String val = value.trim();
            if (val.equalsIgnoreCase("System.out")) {
                this.setWriter(new OutputStreamWriter(System.out));
            } else if (val.equalsIgnoreCase("System.err")) {
                this.setWriter(new OutputStreamWriter(System.err));
            } else {
                this.fileName = val;
            }
        } else if (key.equalsIgnoreCase(APPEND_OPTION)) {
            this.fileAppend = OptionConverter.toBoolean(value, this.fileAppend);
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new QuietWriter(writer, this.errorHandler);
    }

    protected void reset() {
        this.closeFile();
        this.fileName = null;
        if (this.qwIsOurs) {
            super.reset();
        } else {
            this.qw = null;
        }
    }
}

