/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

public class StringVector {
    protected int m_blocksize;
    protected String[] m_map;
    protected int m_firstFree;
    protected int m_mapSize;

    public StringVector() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new String[this.m_blocksize];
    }

    public StringVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new String[n];
    }

    public int getLength() {
        return this.m_firstFree;
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(String string) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            String[] stringArray = new String[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringArray, 0, this.m_firstFree + 1);
            this.m_map = stringArray;
        }
        this.m_map[this.m_firstFree] = string;
        ++this.m_firstFree;
    }

    public final String elementAt(int n) {
        return this.m_map[n];
    }

    public final boolean contains(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean containsIgnoreCase(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final void push(String string) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            String[] stringArray = new String[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringArray, 0, this.m_firstFree + 1);
            this.m_map = stringArray;
        }
        this.m_map[this.m_firstFree] = string;
        ++this.m_firstFree;
    }

    public final String pop() {
        if (this.m_firstFree <= 0) {
            return null;
        }
        --this.m_firstFree;
        String string = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return string;
    }

    public final String peek() {
        if (this.m_firstFree <= 0) {
            return null;
        }
        return this.m_map[this.m_firstFree - 1];
    }
}

