/*
 * @(#)TimerListener
 *
 * $Source: /opt/cvsroot/erserver/src/com/postgres/util/timer/TimerListener.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:41 $
 *
 */

package com.postgres.util.timer;

/**
  * <p>This interface is implemented by classes that wish to
  * receive timer events. The Timer class will invoke the
  * TimerEvent method for every time interval specified when
  * the Timer is started. This gives the implementing class
  * an opportunity to perform some type of time-dependent
  * checking.
  */

public interface TimerListener
{
  /**
    * <p>Called for each timer clock cycle
    */
  void TimerEvent(Object object);
}
