<?
//this function displays results for the file list

include("modules/common/function.inc.php");

function file_list($conn,$id,$page_array,$denyQuickview) {

	//get the files information
	$sql = "SELECT * FROM dm_object WHERE id='$id'";

	$query_return=report_query($conn,$sql);
	$query_myrow=single_myrow_result($query_return[0],0);

	$extension = file_extension($query_myrow["name"]);
	$fileExtension = actual_extension($query_myrow["name"]);

	//we will compare the id to the page_array, and get all pages that
	//match the current id
	$page_count=$page_array[0];
	
	//new_array will contain all matching pages for this id
	$show_page=array();

	for ($row=0;$row<count($page_array[0]);$row++) {
		if ($page_array[0][$row]==$id) {
			$show_page[]=$page_array[1][$row];
		}
	}

	//remove duplicate page numbers and sort
	$show_page = array_values(array_unique($show_page));

	sort($show_page);

	//set the variables for info display
	$datetime		=	date_time_view($query_myrow["create_date"],null);
	$statusdate	=	date_time_view($query_myrow["status_date"],null);
	$file_owner 	= 	username_return($conn,$query_myrow["file_owner"],null);
	$status_owner 	= 	username_return($conn,$query_myrow["status_owner"],null);

	$name = "<a href=\"index.php?module=".SHOW_MOD."&object_id=".$query_myrow["id"]."\" class=main><u>".$query_myrow["name"]."</u></a>";

	//do not show if in prohibited array file.
		
	if (!in_array($fileExtension,$denyQuickview)) {

		//only open a new window if this is a mime type we know, and the user is using ie, or if it's a pdf
		if ((BROWSER=="ie" && $type = file_extension_download($query_myrow["name"])) || $extension=="pdf") $target="_new";
		else $target = "_self";

		$pageArray = array();

		if (count($show_page)>0) {

			for ($row=0;$row<count($show_page);$row++) {

				//enable page matching if pdf file
				if ($extension=="pdf") $showPage="&pageid=".$show_page[$row];

				$pageArray[] = "<a target=".$target." href=\"index.php?module=".VIEW_MOD."&quickview=1&object_id=".$id.$showPage."\" class=main>[Page ".$show_page[$row]."]</a>&nbsp;&nbsp;";

			}
		}
		else {
			$pageArray[] = "<a target=".$target." href=\"index.php?module=".VIEW_MOD."&quickview=1&object_id=".$id."\" class=main>[File]</a>";
		}
	}

	//add the nondependent stuff to our array
	$returnArray = array(
				$query_myrow["id"],		//file id
				$name,				//file name
				$query_myrow["summary"],	//file summary
				$query_myrow["status"],		//checked out status
				$query_myrow["version"],	//file version
				$file_owner,			//file owner
				$datetime,			//date file was created
				$status_owner,			//owner of file mod
				$statusdate,			//date file was updated/checked out
				$pageArray,			//page array of matching pages			
				);
		

	//return our array
	return $returnArray;

	//return nothing if we've made it to here
	return false;
}
		

function execSearch(	$conn,
					$string,
					$search_option,
					$mod_option,
					$date_option,
					$date1,
					$date2) {

	//set our session for our return links on other pages
	$return_link = substr($REQUEST_URI,1);

	//define our variable so we can use case-insensitive searching with different dbs
	$db_like=DB_LIKE;

	//translate our string into the corresponding word ids
	$string = strtolower($string);
	$word_array = explode(" ",$string);

	$passSql = null;

	if (in_array("summary",$search_option)) {

		$passSql .= " summary $db_like '%";
		$passSql .= implode("%' OR summary $db_like '%",$word_array);
		$passSql .= "%'";

	}

	if (in_array("file_name",$search_option)) {

		//we need an OR if the summary option is selected
		if (in_array("summary",$search_option)) $passSql .= " OR ";

		$passSql .=" name $db_like '%";
		$passSql .= implode("%' OR name $db_like '%",$word_array);
		$passSql .= "%'";

	}

	$sql = null;

	if (in_array("file_contents",$search_option)) {
	
		$word_append = implode("' OR dm_docindex.word='",$word_array);
	
		$sql .= " SELECT dm_doclink.file_id AS file_id,
				dm_doclink.page_id AS page_id,
				count(dm_doclink.file_id) AS counter
				FROM dm_doclink
				RIGHT OUTER JOIN dm_docindex ON (dm_doclink.word_id = dm_docindex.id)
				WHERE 
				dm_docindex.word='$word_append' ";

		$sql .= " GROUP BY dm_doclink.file_id,dm_doclink.page_id";

		if ($passSql) $sql .= " UNION ";

	}

	if ($passSql) {
		
		$sql .= " SELECT id AS file_id,1 AS page_id,count(id) AS counter FROM dm_object WHERE ";
		$sql .= $passSql;
		$sql .= " GROUP BY file_id,page_id";
		
	}

	$sql .= " ORDER BY counter,file_id DESC ";

	//intersect the date query

	$sql2 = null;
	
	if ($date_option!="any") {

		$date1 = date("Y-m-d",strtotime($date1));
		$date2 = date("Y-m-d",strtotime($date2));
	
		//set whether we are searching by creation date or last modified date
		if ($mod_option=="enter") $date_string="create_date";
		else $date_string="status_date";

		if ($date_option=="single") 
			$sqlDate.=" AND $date_string $db_like '$date1%'";
		elseif ($date_option=="period") 
			$sqlDate.=" AND ($date_string >='$date1' AND $date_string <= '$date2')";
	
		elseif ($date_option=="before") 
			$sqlDate.=" AND $date_string <= '$date1'";		

		elseif ($date_option=="after") 
			$sqlDate.=" AND $date_string >= '$date1'";

		$sqlDate = substr($sqlDate,4);

		$sql2 = "SELECT id AS file_id FROM dm_object WHERE ";
		$sql2 .= $sqlDate;
		$sql2 .= " GROUP BY file_id";	

	}

	//we need to handle files that are owned by the user, but have no category.
	//the section below handles groups

	//intersect files against files this group is allowed to view
	$group_array = explode(",",USER_GROUPS);

	//if the count is one, all we have is the accountid in here, so we can skip this next part
	if (!bitset_section(BITSET,ADMIN,null)) {

		if ($date_option!="any") $sql2 .= " INTERSECT ";

		$sql2 .= " (SELECT object_id AS file_id FROM dm_file_permissions 
								WHERE (";

		for ($row=0;$row<count($group_array);$row++) {

			$sql2 .= " auth_objectid='$group_array[$row]' OR ";

		}			

		$sql2 = substr($sql2,0,strlen($sql2)-3);

		$sql2 .= ") AND bitset>=2 GROUP BY file_id";

		$sql2 .= " UNION SELECT id AS file_id FROM dm_object WHERE
					file_owner='".USER_ID."' GROUP BY file_id)";

	}


	$query_return=report_query($conn,$sql);

	if ($query_return[1]!=0) {

		$id_array=array_result("file_id",$query_return[0],$query_return[1]);
		$page_id_array=array_result("page_id",$query_return[0],$query_return[1]);

		//create our page array
		$page_array = array($id_array,$page_id_array);

		//check it against our date and permissions
		if ($sql2) {

			$query_return = report_query($conn,$sql2);
			if ($query_return[1]!=0) {

				$id_array2 = array_result("file_id",$query_return[0],$query_return[1]);
				$id_array = array_values(array_intersect($id_array,$id_array2));		

			} else {

				//we set our matches to null since no files with the right permissions were found
				$id_array = null;
			}

		}

		//remove duplicates and sort by id
		if (is_array($id_array)) $id_array=array_values(array_unique($id_array));

		//rsort($id_array);

	}

	$num_result=count($id_array);	

	$search_array = array($id_array,$page_array,$num_result);
		
	return $search_array;

}


function execCategory($conn,$category_value) {


	if ($category_value) {

		//we could do this with an intersect query, but we'd have to go out of our way to order
		//by name

		$sql = "SELECT file_id,UPPER((SELECT name FROM dm_object WHERE id=file_id)) AS name
				 FROM dm_file_cat WHERE cat_id='$category_value' ORDER BY name";

		//if user is not an admin, filter the files they can view

		$query_return=report_query($conn,$sql);
		if ($query_return[1]!=0) $id_array=array_result("file_id",$query_return[0],$query_return[1]);


		//if the user is not an admin, query the permissions for this file
		if (!bitset_section(BITSET,ADMIN,null)) {

			$group_array = explode(",",USER_GROUPS);

			$sql = " (SELECT object_id AS file_id FROM dm_file_permissions 
								WHERE (";
	
			for ($row=0;$row<count($group_array);$row++) {

				$sql .= " auth_objectid='$group_array[$row]' OR ";

			}			

			$sql = substr($sql,0,strlen($sql)-3);

			$sql .= ") AND bitset>=2 GROUP BY file_id";

			$sql .= " UNION SELECT id AS file_id FROM dm_object WHERE
						file_owner='".USER_ID."' GROUP BY file_id)";

			$query_return = report_query($conn,$sql);
			if ($query_return[1]!=0) $id_array2 = array_result("file_id",$query_return[0],$query_return[1]);

			if (is_array($id_array) && is_array($id_array2)) 
					$id_array = array_values(array_intersect($id_array,$id_array2));

		}

	}

	$num_result = count($id_array);

	$cat_array = array($id_array,$num_result);
	return $cat_array;
}


function dmSearch(	$conn,
				$action,
				$search_object,
				$search_option,
				$mod_option,
				$date_option,
				$date1,
				$date2,
				$denyQuickview) {

	if ($action=="search") {

		$search_array = execSearch(	$conn,
								$search_object,
								$search_option,
								$mod_option,
								$date_option,
								$date1,
								$date2);	

		$id_array    = $search_array[0];
		$page_array  = $search_array[1];
		$num_results = $search_array[2];

	}
	else {

		$cat_array = execCategory($conn,$search_object);

		$id_array    = $cat_array[0];
		$page_array  = null;
		$num_results = $cat_array[1];

	}

	$resultArray = array();

	//set the first key to equal the number of returns from the search
	$resultArray[0] = $num_results;

	for ($row=0;$row<count($id_array);$row++) {
	
		$resultArray[] = file_list($conn,$id_array[$row],$page_array,$denyQuickview);

	}

	return $resultArray;

}

function displayResults($resultArray,$color) {

	$id = $resultArray[0];
	$name = $resultArray[1];
	$summary = $resultArray[2];
	$status = $resultArray[3];
	$version = $resultArray[4];
	$file_owner = $resultArray[5];
	$datetime = $resultArray[6];
	$status_owner = $resultArray[7];
	$statusdate = $resultArray[8];
	$pageArray = $resultArray[9]; 

	$file_type = file_extension_name(strip_tags($name));

	if (!$summary) $summary = "No summary available";

	if ($pageArray) $quickview = "QuickView: ".implode("",$pageArray);
	else $quickview= "&nbsp;";

	$created = "Created by ".$file_owner." on ".$datetime[0]." at ".$datetime[1];

	if ($status==1) {
		$status = "<font color=red>Checked Out by ".$status_owner." on ".$statusdate[0]." at ".$statusdate[1]."</font>";
	}
	else {
		if ($version!=1) $status = "Last Modified by ".$status_owner." on ".$statusdate[0]." at ".$statusdate[1];
		$status= "<font color=green>Available for editing</font>";
	}

	$file_type = ereg_replace(" ","&nbsp;",$file_type);

	$string = "<tr class=\"tableContentUnselect\"
			id=\"searchResult".$id."\"	
			onMouseOver=\"changeClass('searchResult".$id."','tableContentSelect');\"
			onMouseOut=\"changeClass('searchResult".$id."','tableContentUnselect');\"
			>

			<td align=right><img src=\"images/file-icon.gif\" border=0></td>
			<td valign=top>
				<table>
				<tr><td>
					".$name."
				</td></tr>
				<tr><td>
					".$file_type."
				</td></tr>
				</table>
			</td><td valign=top>
				<table>
				<tr><td>
					".$summary."
				</td></tr>
				<tr><td>
					".$quickview."
				</td></tr>
				</table>
			</td><td valign=top width=30%>
				<table>
				<tr><td>
					".$created."
				</td></tr>
				<tr><td>
					".$status."
				</td></tr>
				</table>
			</td></tr>
			";


	return $string;

}

if ($action) {

	if (!session_is_registered("date1")) session_register("date1");
	if (!session_is_registered("date2")) session_register("date2");
	if (!session_is_registered("string")) session_register("string");
	if (!session_is_registered("search_option")) session_register("search_option");
	if (!session_is_registered("mod_option")) session_register("mod_option");
	if (!session_is_registered("date_option")) session_register("date_option");

	if ($_POST["date1"]) $date1 = $_POST["date1"];
	if ($_POST["date2"]) $date2 = $_POST["date2"];
	if ($_POST["string"]) $string = $_POST["string"];
	if ($_POST["search_option"]) $search_option = $_POST["search_option"];
	if ($_POST["mod_option"]) $mod_option = $_POST["mod_option"];
	if ($_POST["date_option"]) $date_option = $_POST["date_option"];

}
elseif ($clearForm) {

	session_unregister("date1");
	session_unregister("date2");
	session_unregister("string");
	session_unregister("search_option");
	session_unregister("mod_option");
	session_unregister("date_option");

	$date1 = null;
	$date2 = null;
	$string = null;
	$search_option = null;
	$mod_option = null;
	$date_option = null;

	
}


if ($action || $view_object) {

	if ($action=="search" && !$string) {

		$num_results = "0";
		$display = "<br><div class=\"errorMessage\">&nbsp;&nbsp;&nbsp;You didn't enter anything to search for!</div><br>";
		$action = null;

	}
	else {

		if ($action=="search" || $action=="advance_search") {

			//set default options for left column search
			if (!$search_option) $search_option = array("summary","file_contents","file_name");
			if (!$date_option) $date_option = "any";
			if (!$mod_option) $mod_option = "last";

			$action = "search";
			$search_object = $string;

			$view_object = null;

		}
		else {

			$action = "category";
			$search_object = $view_object;
			$string=name_return($conn,"dm_category",name,$view_object);

		}

		$resultArray = dmSearch(	$conn,
							$action,
							$search_object,
							$search_option,
							$mod_option,	
							$date_option,
							$date1,
							$date2,
							$denyQuickview);

		$num_results = $resultArray[0];


		$leftTitle = $num_results." Matches for \"".$string."\":";
		$rightTitle = "<a href=\"index.php?module=".FIND_MOD."\" class=navBarLink>Search&nbsp;Again</a>";


		if ($num_results > 0) {

			//display our results


			$display = "<table cellpadding=5 cellspacing=0 align=center width=100%>";

			for ($row=1;$row<count($resultArray);$row++) {

				$test = $row % 2;

				if ($test == 1) $color="white";
				else $color = "white";
	
				$display .= displayResults($resultArray[$row],$color);

			}

			$display .= "</table>";

		} else {
	
			$action = null;

		}

	}

}

if ($action==null) {


	//don't show this if it's the result of a search or browse
	if ($display && $view_object) $string = null;
	elseif (!$leftTitle) $leftTitle = "Advanced Search:";

	$rightTitle = "<a href=\"index.php?clearForm=yes\" class=navBarLink>Reset Form</a>&nbsp;&nbsp;&nbsp;&nbsp;
				<input type=submit name=\"advance_search\" value=\"Search\" class=\"submitSmall\">";

	$display .= "

	
		<table cellpadding=5 cellspacing=0 border=0 width=100%>
		<tr><td width=50%>
			&nbsp;&nbsp;Search For:<br>
			&nbsp;&nbsp;<input type=text name=\"string\" value=\"".$string."\" size=35>
		</td><td valign=bottom width=50%>
			Search In:<br>	
			<table cellpadding=0 cellspacing=0>
			<tr><td valign=bottom>
	
	";

	$display .= "<input type=checkbox name=\"search_option[]\" value=\"file_contents\" ";
	if (!$search_option || in_array("file_contents",$search_option)) $display .= " CHECKED ";
	$display .= ">";

	$display .= "
			</td><td>
				File Contents
			</td><td>&nbsp;&nbsp;&nbsp;</td><td valign=bottom>
	";

	$display .= "<input type=checkbox name=\"search_option[]\" value=\"file_name\""; 
	if (!$search_option || in_array("file_name",$search_option)) $display .= " CHECKED ";
	$display .= ">";

	$display .= "
			</td><td>
				File Name
			</td><td>&nbsp;&nbsp;&nbsp;</td><td valign=bottom>
	";

	$display .= "<input type=checkbox name=\"search_option[]\" value=\"summary\"";
 	if (!$search_option || in_array("summary",$search_option)) $display .= " CHECKED ";
	$display .= ">";

	$display .= "

			</td><td>
				File Summary	
			</td></tr>
			</table>

		</td></tr>
		<tr><td colspan=2 width=100%>
			<table width=100% border=0>
			<tr><td valign=top width=33%>
				<table cellpadding=2>
				<tr><td colspan=2>
					When File Was:
				</td></tr>
				<tr><td>
			";


	$display .= "<input type=radio name=\"mod_option\" value=\"last\""; 
	if (!$mod_option || $mod_option=="last") $display .= " CHECKED ";
	$display .= ">";
	
	$display .= "
			</td><td>
				Last Modified
			</td></tr>
			<tr><td> ";

	$display .= "<input type=radio name=\"mod_option\"";
	if ($mod_option=="enter") $display .= " CHECKED ";
	$display .= " value=\"enter\">";

	$display .= "
			</td><td>
				Entered Into System
			</td></tr>
			</table>
		</td><td valign=top width=33%>	
			<table cellpadding=2>
			<tr><td colspan=2>
				During:
			</td></tr>
			<tr><td>
			";

	$display .= "<input type=radio onClick=\"swapDate('any');\" name=\"date_option\" value=\"any\""; 
	if (!$date_option || $date_option=="any") $display .= " CHECKED ";
	$display .= ">";

	$display .= "
			</td><td>
				 Any Date
			</td><td>
				&nbsp;&nbsp;";

	$display .= "<input onClick=\"swapDate('before');\" type=radio name=\"date_option\" value=\"before\"";
	if ($date_option=="before") $display .= " CHECKED ";
	$display .= ">";

	$display .= "
			</td><td>
				Before
			</td></tr>
			<tr><td>";

	$display .= "<input type=radio onClick=\"swapDate('single');\" name=\"date_option\" value=\"single\"";
	if ($date_option=="single") $display .= " CHECKED ";
	$display .= ">";


	$display .= "</td><td>
				On Date
			</td><td>
				&nbsp;&nbsp;";

	$display .= "<input type=radio onClick=\"swapDate('after');\" name=\"date_option\" value=\"after\"";
	if ($date_option=="after") $display .= " CHECKED ";
	$display .= ">";


	$display .= "</td><td>
				After
			</td></tr>
			<tr><td>";

	$display .= "<input type=radio onClick=\"swapDate('period');\" name=\"date_option\" value=\"period\"";
	if ($date_option=="period") $display .= " CHECKED ";
	$display .= ">";


	$display .= "</td><td>
				Time Period
			</td></tr>
			</table>
		</td><td>
			&nbsp;&nbsp;&nbsp;
		</td><td valign=top width=33%>

			<table cellpadding=2>
			<tr><td>
				<div id=\"helpLink\" style=\"visibility:hidden;position:absolute\">
				<a 	href=\"#\" 
					onClick=\"window.open('modules/find/linkhelp.php','_new',config='width=250,height=350');\" 
					class=main>
					Accepted Date Formats:
					</a><br><br>
				</div>
				<div id=\"fromText\" style=\"visibility:hidden;position:absolute\">From:</div>
				<div id=\"onText\" style=\"visibility:hidden;position:absolute\">On:</div>
				<div id=\"beforeText\" style=\"visibility:hidden;position:absolute\">Before:</div>
				<div id=\"afterText\" style=\"visibility:hidden;position:absolute\">After:</div>
				<input type=text name=date1 value=\"".$date1."\" id=\"date1\" style=\"visibility:hidden;position:absolute\"><br>
			</td></tr>
			<tr><td>
				<div id=\"toText\" style=\"visibility:hidden;position:absolute\">To:<br>
				<input type=text name=date2 value=\"".$date2."\">
				</div>
			</td></tr>
			</table>
		</td></tr>				
		</table>
	</td></tr>
	<!-- end date form -->
	</table>
	";

	if ($date_option) {
		
		$display .= "
			<!-- create the javascript to show the date fields -->
			<script language=\"javascript\">\n
			swapDate('".$date_option."');\n
			</script>\n
			";

	}
}

?>
