""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from map import *
from set import *

class Vertex(Map):
	"the vertex class"
	
	type = 'Vertex'
	
	def __init__(self, object):
		Map.__init__(self, str(object))
		self.object = object
		self.tag = None
		
	def __setitem__(self, label, vertex):
		if self.has_key(label):
			set = self[label]
		else:
			set = Set()
			Map.__setitem__(self, label, set)
		set.insert(vertex)

	def __getitem__(self, label):
		if self.has_key(label):
			return Map.__getitem__(self, label)
		return Set()

	def __repr__(self):
		xmlstr = "<vertex name='%s'>\n" % self.name
		xmlstr = "%s<pair>\n" % xmlstr
		xmlstr = "%s<value>%s</value>\n" % (xmlstr, `self.object`)
		xmlstr = "%s<edges>\n" % xmlstr
		for (label, vertices) in self.items():
			xmlstr = "%s<pair>\n" % xmlstr
			xmlstr = "%s<label>%s</label>\n" % (xmlstr, `label`)
			xmlstr = "%s<vertices>\n" % xmlstr
			for vertex in vertices.values():
				xmlstr = "%s<vertex name='%s'/>\n" % (xmlstr,str(vertex))
			xmlstr = "%s</vertices>\n" % xmlstr			
			xmlstr = "%s</pair>\n" % xmlstr
		xmlstr = "%s</edges>\n" % xmlstr
		xmlstr = "%s</pair>\n" % xmlstr
		return "%s</vertex>" % xmlstr

	def degre(self):
		"return the degre of a vertex"
		degre = 0
		for vertices in self.values():
			degre = degre + len(vertices.values()) # TODO !!!!
		return degre
			
class Graph(Set):
	"the graph class, here a set of vertices"

	type = 'Graph'
	
	def __init__(self, name = 'Graph'):
		Set.__init__(self, name)
		self.directed = 1
		
	def insert(self, object):
		"return a vertex"
		return Set.insert(self,Vertex(object))
		
	def insert_edge(self, object1, label, object2):
		vertex1 = self.insert(object1)
		vertex2 = self.insert(object2)
		vertex1[label] = vertex2
		if not self.directed:
			vertex2[label] = vertex1
			
	def clear_tags(self):
		for v in self.values():
			v.tag = None

	def _get_dfs_path(self, object1, object2):
		v1 = self[object1]
		v2 = self[object2]
		if v1 and v2:
			v1.tag = "tagged"
			for (label, vertices) in v1.items():
				for v in vertices.values():
					if v.tag:
						continue
					if v == v2:
						return [ (v1, label, v) ]
					else:
						subpath = self._get_dfs_path(v, v2)
						if subpath:
							return [ (v1, label, v) ] + subpath
		return []

	def get_dfs_path(self, object1, object2):
		self.clear_tags()
		return self._get_dfs_path(object1, object2)
