# $Id: proposal_cat_adm.pm,v 1.5 2003/12/20 04:14:51 mig Exp $
######################################
# Comas - Conference Management System
######################################
# Copyright 2003 CONSOL
# Congreso Nacional de Software Libre (http://www.consol.org.mx/)
#   Gunnar Wolf <gwolf@gwolf.cx>
#   Manuel Rabade <mig@mig-29.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################

######################################
# Module: Comas::Admin::proposal_cat_adm
# Manage Comas proposal catalogs
######################################
# Depends on:
#
# Comas::Common - Common functions for various Comas modules
# Comas::Admin - Manage administrative tasks for a Comas database

# This module is not meant to be called on its own, it should be called from
# Comas::Admin.
package Comas::Admin::proposal_cat_adm;

use strict;
use warnings;
use Carp;
use Comas::Admin;
use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(create_track create_prop_status create_prop_type
		    set_track set_prop_status set_prop_type
		    delete_track delete_prop_status delete_prop_type);
our %EXPORT_TAGS = (track => [qw(create_track set_track delete_track)], 
		    prop_status => [qw(create_prop_status 
				       delete_prop_status set_prop_status)],
		    prop_type => [qw(create_prop_type set_prop_type 
				     delete_prop_type)]);

=head1 NAME

Comas::Admin::proposal_cat_adm - Manage Comas proposal catalogs

=head1 SYNOPSIS

This module is not meant to be used by itself, but as an auxiliary to
L<Comas::Admin|Comas::Admin>. Please check L<Comas::Admin|Comas::Admin>'s
documentation, in the B<Person-related catalog administration> section, for
further details on the usage for this functions.

=head1 SEE ALSO

L<Comas::Admin|Comas::Admin> module documentation

=head1 AUTHOR

Gunnar Wolf, gwolf@gwolf.cx

Manuel Rabade, mig@mig-29.net

Comas has been developed for CONSOL, Congreso Nacional de Software Libre,
http://www.consol.org.mx/

=head1 COPYRIGHT

Copyright 2003 Gunnar Wolf and Manuel Rabade

This library is free software, you can redistribute it and/or modify it
under the terms of the GPL version 2 or later.

=cut

sub create_track {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'track', $descr);
}

sub create_prop_status {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'prop_status', $descr);
}

sub create_prop_type {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'prop_type', $descr);
}

sub set_track {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'track', $id, $descr);
}

sub set_prop_status {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'prop_status', $id, $descr);
}

sub set_prop_type {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'prop_type', $id, $descr);
}

sub delete_track {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'track', $id);
}

sub delete_prop_status {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'prop_status', $id);
}

sub delete_prop_type {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'proposal_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'prop_type', $id);
}

1;

# $Log: proposal_cat_adm.pm,v $
# Revision 1.5  2003/12/20 04:14:51  mig
# - Agrego tags Id y Log que expanda el CVS
#
