-- The following functions are the minimum required for case-insensitive text (citext)

-- Adjust this setting to control where the objects get created.
-- pg_catalog in my opinion is a good place because it doesnt get backed up and we dont need it backed up
-- Currently this is only possible because we don't have any tables. This may not work in the future.

SET search_path = pg_catalog;

BEGIN;

-- inout and ouput routines
CREATE FUNCTION citextin(cstring) RETURNS citext AS 'textin'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citextin(cstring) TO PUBLIC;
COMMENT ON FUNCTION citextin(cstring) IS 'Input for case insensitive text';

CREATE FUNCTION citextout(citext) RETURNS cstring AS 'textout'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citextout(citext) TO PUBLIC;
COMMENT ON FUNCTION citextout(citext) IS 'Output for case insensitive text';

-- type definition
CREATE TYPE citext(INPUT = citextin, OUTPUT = citextout, INTERNALLENGTH = -1, DELIMITER = ",", ALIGNMENT = int4, STORAGE = MAIN);
COMMENT ON TYPE citext IS 'variable-length case-insensitve string, no limit specified';

-- implicit type casts
CREATE CAST (citext AS text) WITHOUT FUNCTION AS IMPLICIT;
CREATE CAST (text AS citext) WITHOUT FUNCTION AS IMPLICIT;
CREATE CAST (citext AS varchar) WITHOUT FUNCTION AS IMPLICIT;
CREATE CAST (varchar AS citext) WITHOUT FUNCTION AS IMPLICIT;
CREATE CAST (citext AS bpchar) WITHOUT FUNCTION AS IMPLICIT;
CREATE CAST (bpchar AS citext) WITHOUT FUNCTION AS IMPLICIT;

-- Functions for standard operators citext : citext
CREATE FUNCTION citext_eq(citext, citext) RETURNS bool AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_eq(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_eq(citext, citext) IS '= operator for citext';

CREATE FUNCTION citext_ne(citext, citext) RETURNS bool AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_ne(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_ne(citext, citext) IS '<> operator for citext';

CREATE FUNCTION citext_lt(citext, citext) RETURNS bool AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_lt(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_lt(citext, citext) IS '< operator for citext';

CREATE FUNCTION citext_le(citext, citext) RETURNS bool AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_le(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_le(citext, citext) IS '<= operator for citext';

CREATE FUNCTION citext_gt(citext, citext) RETURNS bool AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_gt(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_gt(citext, citext) IS '> operator for citext';

CREATE FUNCTION citext_ge(citext, citext) RETURNS bool AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_ge(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_ge(citext, citext) IS '>= operator for citext';

CREATE FUNCTION textcat(citext, citext) RETURNS citext AS 'textcat'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION textcat(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION textcat(citext, citext) IS 'concatenate';

-- standard Operators citext : citext
CREATE OPERATOR < (PROCEDURE = citext_lt, LEFTARG = citext, RIGHTARG = citext, COMMUTATOR = OPERATOR(>), NEGATOR = OPERATOR(>=), RESTRICT = scalarltsel, JOIN = scalarltjoinsel);
CREATE OPERATOR <= (PROCEDURE = citext_le, LEFTARG = citext, RIGHTARG = citext, COMMUTATOR = OPERATOR(>=), NEGATOR = OPERATOR(>), RESTRICT = scalarltsel, JOIN = scalarltjoinsel);
CREATE OPERATOR <> (PROCEDURE = citext_ne, LEFTARG = citext, RIGHTARG = citext, COMMUTATOR = OPERATOR(<>), NEGATOR = OPERATOR(=), RESTRICT = neqsel, JOIN = neqjoinsel);
CREATE OPERATOR = (PROCEDURE = citext_eq, LEFTARG = citext, RIGHTARG = citext, COMMUTATOR = OPERATOR(=), NEGATOR = OPERATOR(<>), RESTRICT = eqsel, JOIN = eqjoinsel);
CREATE OPERATOR > (PROCEDURE = citext_gt, LEFTARG = citext, RIGHTARG = citext, COMMUTATOR = OPERATOR(<), NEGATOR = OPERATOR(<=), RESTRICT = scalargtsel, JOIN = scalargtjoinsel);
CREATE OPERATOR >= (PROCEDURE = citext_ge, LEFTARG = citext, RIGHTARG = citext, COMMUTATOR = OPERATOR(<=), NEGATOR = OPERATOR(<), RESTRICT = scalargtsel, JOIN = scalargtjoinsel);
CREATE OPERATOR || (PROCEDURE = textcat, LEFTARG = citext, RIGHTARG = citext);

-- comparison functions for operator classes (indexing)
CREATE FUNCTION citextcmp(citext, citext) RETURNS int4 AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citextcmp(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citextcmp(citext, citext) IS 'comparison function for btree indexing of citext';

CREATE FUNCTION citext_smaller(citext, citext) RETURNS citext AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_smaller(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_smaller(citext, citext) IS 'smaller of two';

CREATE FUNCTION citext_larger(citext, citext) RETURNS citext AS 'citext' LANGUAGE 'C' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext_larger(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION citext_larger(citext, citext) IS 'smaller of two';

-- operator class (indexing)
CREATE OPERATOR CLASS citext_ops
	DEFAULT FOR	TYPE 	citext USING btree AS
	OPERATOR 	1	<(citext,citext) ,
	OPERATOR 	2 	<=(citext,citext) ,
	OPERATOR 	3 	=(citext,citext) ,
	OPERATOR 	4 	>=(citext,citext) ,
	OPERATOR 	5 	>(citext,citext) ,
	FUNCTION 	1	citextcmp(citext, citext);

-- size functions
CREATE FUNCTION textlen(citext) RETURNS int4 AS 'textlen'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION textlen(citext) TO PUBLIC;
COMMENT ON FUNCTION textlen(citext) IS 'length';
CREATE FUNCTION length(citext) RETURNS int4 AS 'textlen'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION length(citext) TO PUBLIC;
COMMENT ON FUNCTION length(citext) IS 'length';

-- Functions for regular expression operators citext : citext
CREATE FUNCTION texticlike(citext, citext) RETURNS bool AS 'texticlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticlike(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION texticlike(citext, citext) IS 'matches LIKE expression, case-insensitive';

CREATE FUNCTION texticnlike(citext, citext) RETURNS bool AS 'texticnlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticnlike(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION texticnlike(citext, citext) IS 'does not match LIKE expression, case-insensitive';

CREATE FUNCTION texticregexeq(citext, citext) RETURNS bool AS 'texticregexeq'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexeq(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexeq(citext, citext) IS 'matches regex., case-insensitive';

CREATE FUNCTION texticregexne(citext, citext) RETURNS bool AS 'texticregexne'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexne(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexne(citext, citext) IS 'does not match regex., case-insensitive';

-- regular expression Operators citext : citext
CREATE OPERATOR ~ (PROCEDURE = texticregexeq, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(!~), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR ~* (PROCEDURE = texticregexeq, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(!~*), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR !~ (PROCEDURE = texticregexne, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(~), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR !~* (PROCEDURE = texticregexne, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(~*), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR ~~ (PROCEDURE = texticlike, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(!~~), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR ~~* (PROCEDURE = texticlike, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(!~~*), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR !~~ (PROCEDURE = texticnlike, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(~~), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);
CREATE OPERATOR !~~* (PROCEDURE = texticnlike, LEFTARG = citext, RIGHTARG = citext, NEGATOR = OPERATOR(~~*), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);

-- Functions for regular expression Operators name : citext
CREATE FUNCTION nameicregexne(name, citext) RETURNS bool AS 'nameicregexne'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION nameicregexne(name, citext) TO PUBLIC;
COMMENT ON FUNCTION nameicregexne(name, citext) IS 'does not match regex., case-insensitive';
CREATE FUNCTION nameicregexeq(name, citext) RETURNS bool AS 'nameicregexeq'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION nameicregexeq(name, citext) TO PUBLIC;
COMMENT ON FUNCTION nameicregexeq(name, citext) IS 'matches regex., case-insensitive';
CREATE FUNCTION nameicnlike(name, citext) RETURNS bool AS 'nameicnlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION nameicnlike(name, citext) TO PUBLIC;
COMMENT ON FUNCTION nameicnlike(name, citext) IS 'does not match LIKE expression, case-insensitive';
CREATE FUNCTION nameiclike(name, citext) RETURNS bool AS 'nameiclike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION nameiclike(name, citext) TO PUBLIC;
COMMENT ON FUNCTION nameiclike(name, citext) IS 'matches LIKE expression, case-insensitive';

-- regular expression Operators name : citext
CREATE OPERATOR ~ (PROCEDURE = nameicregexeq, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(!~), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR ~* (PROCEDURE = nameicregexeq, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(!~*), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR !~ (PROCEDURE = nameicregexne, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(~), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR !~* (PROCEDURE = nameicregexne, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(~*), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR ~~ (PROCEDURE = nameiclike, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(!~~), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR ~~* (PROCEDURE = nameiclike, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(!~~*), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR !~~ (PROCEDURE = nameicnlike, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(~~), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);
CREATE OPERATOR !~~* (PROCEDURE = nameicnlike, LEFTARG = name, RIGHTARG = citext, NEGATOR = OPERATOR(~~), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);

-- Functions for regular expression Operators varchar : citext
CREATE FUNCTION texticlike(varchar, citext) RETURNS bool AS 'texticlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticlike(varchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticlike(varchar, citext) IS 'matches LIKE expression, case-insensitive';
CREATE FUNCTION texticnlike(varchar, citext) RETURNS bool AS 'texticnlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticnlike(varchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticnlike(varchar, citext) IS 'does not match LIKE expression, case-insensitive';
CREATE FUNCTION texticregexeq(varchar, citext) RETURNS bool AS 'texticregexeq'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexeq(varchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexeq(varchar, citext) IS 'matches regex., case-insensitive';
CREATE FUNCTION texticregexne(varchar, citext) RETURNS bool AS 'texticregexne'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexne(varchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexne(varchar, citext) IS 'does not match regex., case-insensitive';

-- regular expression Operators varchar : citext
CREATE OPERATOR ~ (PROCEDURE = texticregexeq, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR ~* (PROCEDURE = texticregexeq, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~*), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR !~ (PROCEDURE = texticregexne, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(~), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR !~* (PROCEDURE = texticregexne, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(~*), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR ~~ (PROCEDURE = texticlike, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~~), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR ~~* (PROCEDURE = texticlike, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~~*), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR !~~ (PROCEDURE = texticnlike, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(~~), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);
CREATE OPERATOR !~~* (PROCEDURE = texticnlike, LEFTARG = varchar, RIGHTARG = citext, NEGATOR = OPERATOR(~~*), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);

-- Functions for regular expression Operators bpchar : citext
CREATE FUNCTION texticlike(bpchar, citext) RETURNS bool AS 'texticlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticlike(bpchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticlike(bpchar, citext) IS 'matches LIKE expression, case-insensitive';
CREATE FUNCTION texticnlike(bpchar, citext) RETURNS bool AS 'texticnlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticnlike(bpchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticnlike(bpchar, citext) IS 'does not match LIKE expression, case-insensitive';
CREATE FUNCTION texticregexeq(bpchar, citext) RETURNS bool AS 'texticregexeq'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexeq(bpchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexeq(bpchar, citext) IS 'matches regex., case-insensitive';
CREATE FUNCTION texticregexne(bpchar, citext) RETURNS bool AS 'texticregexne'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexne(bpchar, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexne(bpchar, citext) IS 'does not match regex., case-insensitive';

-- regular expression Operators bpchar : citext
CREATE OPERATOR ~ (PROCEDURE = texticregexeq, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR ~* (PROCEDURE = texticregexeq, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~*), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR !~ (PROCEDURE = texticregexne, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(~), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR !~* (PROCEDURE = texticregexne, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(~*), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR ~~ (PROCEDURE = texticlike, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~~), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR ~~* (PROCEDURE = texticlike, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(!~~*), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR !~~ (PROCEDURE = texticnlike, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(~~), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);
CREATE OPERATOR !~~* (PROCEDURE = texticnlike, LEFTARG = bpchar, RIGHTARG = citext, NEGATOR = OPERATOR(~~*), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);

-- Functions for regular expression Operators text : citext
CREATE FUNCTION texticlike(text, citext) RETURNS bool AS 'texticlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticlike(text, citext) TO PUBLIC;
COMMENT ON FUNCTION texticlike(text, citext) IS 'matches LIKE expression, case-insensitive';
CREATE FUNCTION texticnlike(text, citext) RETURNS bool AS 'texticnlike'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticnlike(text, citext) TO PUBLIC;
COMMENT ON FUNCTION texticnlike(text, citext) IS 'does not match LIKE expression, case-insensitive';
CREATE FUNCTION texticregexeq(text, citext) RETURNS bool AS 'texticregexeq'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexeq(text, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexeq(text, citext) IS 'matches regex., case-insensitive';
CREATE FUNCTION texticregexne(text, citext) RETURNS bool AS 'texticregexne'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION texticregexne(text, citext) TO PUBLIC;
COMMENT ON FUNCTION texticregexne(text, citext) IS 'does not match regex., case-insensitive';

-- regular expression Operators text : citext
CREATE OPERATOR ~ (PROCEDURE = texticregexeq, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(!~), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR ~* (PROCEDURE = texticregexeq, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(!~*), RESTRICT = icregexeqsel, JOIN = icregexeqjoinsel);
CREATE OPERATOR !~ (PROCEDURE = texticregexne, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(~), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR !~* (PROCEDURE = texticregexne, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(~*), RESTRICT = icregexnesel, JOIN = icregexnejoinsel);
CREATE OPERATOR ~~ (PROCEDURE = texticlike, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(!~~), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR ~~* (PROCEDURE = texticlike, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(!~~*), RESTRICT = iclikesel, JOIN = iclikejoinsel);
CREATE OPERATOR !~~ (PROCEDURE = texticnlike, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(~~), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);
CREATE OPERATOR !~~* (PROCEDURE = texticnlike, LEFTARG = text, RIGHTARG = citext, NEGATOR = OPERATOR(~~*), RESTRICT = icnlikesel, JOIN = icnlikejoinsel);

-- Miscelaneous functions
-- These functions all just overloaded versions of the internal functions for text
CREATE FUNCTION lower(citext) RETURNS citext AS 'lower'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION lower(citext) TO PUBLIC;
COMMENT ON FUNCTION lower(citext) IS 'Convert case insensitive text to lowercase (why?)';

CREATE FUNCTION upper(citext) RETURNS citext AS 'upper'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION upper(citext) TO PUBLIC;
COMMENT ON FUNCTION upper(citext) IS 'Convert case insensitive text to uppercase (why?)';

CREATE FUNCTION btrim(citext, citext) RETURNS citext AS 'btrim'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION btrim(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION btrim(citext, citext) IS 'trim both ends of string';

CREATE FUNCTION btrim(citext) RETURNS citext AS 'select btrim($1, '' ''::citext)'  LANGUAGE 'sql' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION btrim(citext) TO PUBLIC;
COMMENT ON FUNCTION btrim(citext) IS 'trim both ends of string';

CREATE FUNCTION ltrim(citext, citext) RETURNS citext AS 'ltrim'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION ltrim(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION ltrim(citext, citext) IS 'left-pad string to length';

CREATE FUNCTION ltrim(citext) RETURNS citext AS 'select ltrim($1, '' ''::citext)'  LANGUAGE 'sql' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION ltrim(citext) TO PUBLIC;
COMMENT ON FUNCTION ltrim(citext) IS 'remove initial characters from string';

CREATE FUNCTION rtrim(citext, citext) RETURNS citext AS 'rtrim'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION rtrim(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION rtrim(citext, citext) IS 'right-pad string to length';

CREATE FUNCTION rtrim(citext) RETURNS citext AS 'select rtrim($1, '' ''::citext)'  LANGUAGE 'sql' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION rtrim(citext) TO PUBLIC;
COMMENT ON FUNCTION rtrim(citext) IS 'remove trailing characters from string';

CREATE FUNCTION lpad(citext, int4, citext) RETURNS citext AS 'lpad'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION lpad(citext, int4, citext) TO PUBLIC;
COMMENT ON FUNCTION lpad(citext, int4, citext) IS 'left-pad string to length';

CREATE FUNCTION lpad(citext, int4) RETURNS citext AS 'select lpad($1, $2, '' '')'  LANGUAGE 'sql' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION lpad(citext, int4) TO PUBLIC;
COMMENT ON FUNCTION lpad(citext, int4) IS 'left-pad string to length';

CREATE FUNCTION rpad(citext, int4, citext) RETURNS citext AS 'rpad'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION rpad(citext, int4, citext) TO PUBLIC;
COMMENT ON FUNCTION rpad(citext, int4, citext) IS 'right-pad string to length';

CREATE FUNCTION rpad(citext, int4) RETURNS citext AS 'select rpad($1, $2, '' ''::citext)'  LANGUAGE 'sql' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION rpad(citext, int4) TO PUBLIC;
COMMENT ON FUNCTION rpad(citext, int4) IS 'right-pad string to length';

CREATE FUNCTION repeat(citext, int4) RETURNS citext AS 'repeat'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION repeat(citext, int4) TO PUBLIC;
COMMENT ON FUNCTION repeat(citext, int4) IS 'replicate string int4 times';

CREATE FUNCTION "substring"(citext, int4, int4) RETURNS citext AS 'text_substr'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION "substring"(citext, int4, int4) TO PUBLIC;
COMMENT ON FUNCTION "substring"(citext, int4, int4) IS 'return portion of string';

CREATE FUNCTION "substring"(citext, int4) RETURNS citext AS 'text_substr_no_len'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION "substring"(citext, int4) TO PUBLIC;
COMMENT ON FUNCTION "substring"(citext, int4) IS 'return portion of string';

CREATE FUNCTION substr(citext, int4, int4) RETURNS citext AS 'text_substr'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION substr(citext, int4, int4) TO PUBLIC;
COMMENT ON FUNCTION substr(citext, int4, int4) IS 'return portion of string';

CREATE FUNCTION substr(citext, int4) RETURNS citext AS 'text_substr_no_len'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION substr(citext, int4) TO PUBLIC;
COMMENT ON FUNCTION substr(citext, int4) IS 'return portion of string';

CREATE FUNCTION to_timestamp(citext, citext) RETURNS timestamptz AS 'to_timestamp'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION to_timestamp(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION to_timestamp(citext, citext) IS 'convert citext to timestamp';

CREATE FUNCTION to_number(citext, citext) RETURNS "numeric" AS 'numeric_to_number'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_number(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION to_number(citext, citext) IS 'convert citext to numeric';

CREATE FUNCTION to_date(citext, citext) RETURNS "date" AS 'to_date'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_date(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION to_date(citext, citext) IS 'convert citext to date';

CREATE FUNCTION to_char("interval", citext) RETURNS citext AS 'interval_to_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char("interval", citext) TO PUBLIC;
COMMENT ON FUNCTION to_char("interval", citext) IS 'format interval to citext';

CREATE FUNCTION to_char(float8, citext) RETURNS citext AS 'float8_to_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char(float8, citext) TO PUBLIC;
COMMENT ON FUNCTION to_char(float8, citext) IS 'format float8 to citext';

CREATE FUNCTION to_char(float4, citext) RETURNS citext AS 'float4_to_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char(float4, citext) TO PUBLIC;
COMMENT ON FUNCTION to_char(float4, citext) IS 'format float4 to citext';

CREATE FUNCTION to_char(int8, citext) RETURNS citext AS 'int8_to_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char(int8, citext) TO PUBLIC;
COMMENT ON FUNCTION to_char(int8, citext) IS 'format int8 to citext';

CREATE FUNCTION to_char(int4, citext) RETURNS citext AS 'int4_to_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char(int4, citext) TO PUBLIC;
COMMENT ON FUNCTION to_char(int4, citext) IS 'format int4 to citext';

CREATE FUNCTION to_char(numeric, citext) RETURNS citext AS 'numeric_to_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char(numeric, citext) TO PUBLIC;
COMMENT ON FUNCTION to_char("numeric", citext) IS 'format numeric to citext';

CREATE FUNCTION to_char(timestamptz, citext) RETURNS citext AS 'timestamptz_to_char'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char(timestamptz, citext) TO PUBLIC;
COMMENT ON FUNCTION to_char(timestamptz, citext) IS 'format timestamp with time zone to citext';

CREATE FUNCTION to_char("timestamp", citext) RETURNS citext AS 'timestamp_to_char'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION to_char("timestamp", citext) TO PUBLIC;
COMMENT ON FUNCTION to_char("timestamp", citext) IS 'format timestamp to citext';

CREATE FUNCTION to_ascii(citext, name) RETURNS citext AS 'to_ascii_encname'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_ascii(citext, name) TO PUBLIC;
COMMENT ON FUNCTION to_ascii(citext, name) IS 'encode citext from encoding to ASCII citext';

CREATE FUNCTION to_ascii(citext, int4) RETURNS citext AS 'to_ascii_enc'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_ascii(citext, int4) TO PUBLIC;
COMMENT ON FUNCTION to_ascii(citext, int4) IS 'encode citext from encoding to ASCII citext';

CREATE FUNCTION to_ascii(citext) RETURNS citext AS 'to_ascii_default'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION to_ascii(citext) TO PUBLIC;
COMMENT ON FUNCTION to_ascii(citext) IS 'encode citext from DB encoding to ASCII citext';

CREATE FUNCTION citext(oid) RETURNS citext AS 'oid_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(oid) TO PUBLIC;
COMMENT ON FUNCTION citext(oid) IS 'convert oid to citext';
CREATE FUNCTION oid(citext) RETURNS oid AS 'text_oid'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION oid(citext) TO PUBLIC;
COMMENT ON FUNCTION oid(citext) IS 'convert citext to oid';
CREATE CAST (citext AS oid) WITH FUNCTION oid(citext);
CREATE CAST (oid AS citext) WITH FUNCTION citext(oid);

CREATE FUNCTION citext(int2) RETURNS citext AS 'int2_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(int2) TO PUBLIC;
COMMENT ON FUNCTION citext(int2) IS 'convert int2 to citext';
CREATE FUNCTION int2(citext) RETURNS int2 AS 'text_int2'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION int2(citext) TO PUBLIC;
COMMENT ON FUNCTION int2(citext) IS 'convert citext to int2';
CREATE CAST (citext AS int2) WITH FUNCTION int2(citext);
CREATE CAST (int2 AS citext) WITH FUNCTION citext(int2);

CREATE FUNCTION citext(int4) RETURNS citext AS 'int4_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(int4) TO PUBLIC;
COMMENT ON FUNCTION citext(int4) IS 'convert int4 to citext';
CREATE FUNCTION int4(citext) RETURNS int4 AS 'text_int4'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION int4(citext) TO PUBLIC;
COMMENT ON FUNCTION int4(citext) IS 'convert citext to int4';
CREATE CAST (citext AS int4) WITH FUNCTION int4(citext);
CREATE CAST (int4 AS citext) WITH FUNCTION citext(int4);

CREATE FUNCTION citext(name) RETURNS citext AS 'name_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(name) TO PUBLIC;
COMMENT ON FUNCTION citext(name) IS 'convert name to citext';
CREATE FUNCTION name(citext) RETURNS name AS 'text_name'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION name(citext) TO PUBLIC;
COMMENT ON FUNCTION name(citext) IS 'convert citext to name';
CREATE CAST (citext AS name) WITH FUNCTION name(citext);
CREATE CAST (name AS citext) WITH FUNCTION citext(name);

CREATE FUNCTION citext(float8) RETURNS citext AS 'float8_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(float8) TO PUBLIC;
COMMENT ON FUNCTION citext(float8) IS 'convert float8 to citext';
CREATE FUNCTION float8(citext) RETURNS float8 AS 'text_float8'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION float8(citext) TO PUBLIC;
COMMENT ON FUNCTION float8(citext) IS 'convert citext to float8';
CREATE CAST (citext AS float8) WITH FUNCTION float8(citext);
CREATE CAST (float8 AS citext) WITH FUNCTION citext(float8);

CREATE FUNCTION citext(float4) RETURNS citext AS 'float4_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(float4) TO PUBLIC;
COMMENT ON FUNCTION citext(float4) IS 'convert float4 to citext';
CREATE FUNCTION float4(citext) RETURNS float4 AS 'text_float4'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION float4(citext) TO PUBLIC;
COMMENT ON FUNCTION float4(citext) IS 'convert citext to float4';
CREATE CAST (citext AS float4) WITH FUNCTION float4(citext);
CREATE CAST (float4 AS citext) WITH FUNCTION citext(float4);

CREATE FUNCTION citext("char") RETURNS citext AS 'char_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext("char") TO PUBLIC;
COMMENT ON FUNCTION citext("char") IS 'convert char to citext';
CREATE FUNCTION "char"(citext) RETURNS "char" AS 'text_char'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION "char"(citext) TO PUBLIC;
COMMENT ON FUNCTION "char"(citext) IS 'convert citext to char';
CREATE CAST (citext AS "char") WITH FUNCTION "char"(citext);
CREATE CAST ("char" AS citext) WITH FUNCTION citext("char");

CREATE FUNCTION citext(timetz) RETURNS citext AS 'timetz_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(timetz) TO PUBLIC;
COMMENT ON FUNCTION citext(timetz) IS 'convert timetz to citext';
CREATE FUNCTION timetz(citext) RETURNS timetz AS 'text_timetz'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION timetz(citext) TO PUBLIC;
COMMENT ON FUNCTION timetz(citext) IS 'convert citext to timetz';
CREATE CAST (citext AS timetz) WITH FUNCTION timetz(citext);
CREATE CAST (timetz AS citext) WITH FUNCTION citext(timetz);

CREATE FUNCTION citext("time") RETURNS citext AS 'time_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext("time") TO PUBLIC;
COMMENT ON FUNCTION citext("time") IS 'convert time to citext';
CREATE FUNCTION "time"(citext) RETURNS "time" AS 'text_time'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION "time"(citext) TO PUBLIC;
COMMENT ON FUNCTION "time"(citext) IS 'convert citext to time';
CREATE CAST (citext AS "time") WITH FUNCTION "time"(citext);
CREATE CAST ("time" AS citext) WITH FUNCTION citext("time");

CREATE FUNCTION citext("date") RETURNS citext AS 'date_text'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION citext("date") TO PUBLIC;
COMMENT ON FUNCTION citext("date") IS 'convert date to citext';
CREATE FUNCTION "date"(citext) RETURNS "date" AS 'text_date'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION "date"(citext) TO PUBLIC;
COMMENT ON FUNCTION "date"(citext) IS 'convert citext to date';
CREATE CAST (citext AS date) WITH FUNCTION "date"(citext);
CREATE CAST ("date" AS citext) WITH FUNCTION citext("date");

CREATE FUNCTION citext(timestamptz) RETURNS citext AS 'timestamptz_text'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(timestamptz) TO PUBLIC;
COMMENT ON FUNCTION citext(timestamptz) IS 'convert timestamp to citext';
CREATE FUNCTION timestamptz(citext) RETURNS timestamptz AS 'text_timestamptz'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION timestamptz(citext) TO PUBLIC;
COMMENT ON FUNCTION timestamptz(citext) IS 'convert citext to timestamp with time zone';
CREATE CAST (citext AS timestamptz) WITH FUNCTION timestamptz(citext);
CREATE CAST (timestamptz AS citext) WITH FUNCTION citext(timestamptz);

CREATE FUNCTION citext("interval") RETURNS citext AS 'interval_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext("interval") TO PUBLIC;
COMMENT ON FUNCTION citext("interval") IS 'convert interval to citext';
CREATE FUNCTION "interval"(citext) RETURNS "interval" AS 'text_interval'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION "interval"(citext) TO PUBLIC;
COMMENT ON FUNCTION "interval"(citext) IS 'convert citext to interval';
CREATE CAST (citext AS "interval") WITH FUNCTION "interval"(citext);
CREATE CAST ("interval" AS citext) WITH FUNCTION citext("interval");

CREATE FUNCTION citext(int8) RETURNS citext AS 'int8_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(int8) TO PUBLIC;
COMMENT ON FUNCTION citext(int8) IS 'convert int8 to citext';
CREATE FUNCTION int8(citext) RETURNS int8 AS 'text_int8'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION int8(citext) TO PUBLIC;
COMMENT ON FUNCTION int8(citext) IS 'convert citext to int8';
CREATE CAST (citext AS int8) WITH FUNCTION int8(citext);
CREATE CAST (int8 AS citext) WITH FUNCTION citext(int8);

CREATE FUNCTION citext(macaddr) RETURNS citext AS 'macaddr_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(macaddr) TO PUBLIC;
COMMENT ON FUNCTION citext(macaddr) IS 'MAC address to citext';
CREATE FUNCTION macaddr(citext) RETURNS macaddr AS 'text_macaddr'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION macaddr(citext) TO PUBLIC;
COMMENT ON FUNCTION macaddr(citext) IS 'citext to MAC address';
CREATE CAST (citext AS macaddr) WITH FUNCTION macaddr(citext);
CREATE CAST (macaddr AS citext) WITH FUNCTION citext(macaddr);

CREATE FUNCTION citext("numeric") RETURNS citext AS 'numeric_text'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext("numeric") TO PUBLIC;
COMMENT ON FUNCTION citext("numeric") IS 'Numeric to citext';
CREATE FUNCTION "numeric"(citext) RETURNS "numeric" AS 'text_numeric'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION "numeric"(citext) TO PUBLIC;
COMMENT ON FUNCTION "numeric"(citext) IS 'citext to numeric';
CREATE CAST (citext AS "numeric") WITH FUNCTION "numeric"(citext);
CREATE CAST ("numeric" AS citext) WITH FUNCTION citext("numeric");

CREATE FUNCTION citext("timestamp") RETURNS citext AS 'timestamp_text'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION citext("timestamp") TO PUBLIC;
COMMENT ON FUNCTION citext("timestamp") IS 'convert timestamp to citext';
CREATE FUNCTION "timestamp"(citext) RETURNS "timestamp" AS 'text_timestamp'  LANGUAGE 'internal' STABLE STRICT;
GRANT EXECUTE ON FUNCTION "timestamp"(citext) TO PUBLIC;
COMMENT ON FUNCTION "timestamp"(citext) IS 'convert citext to timestamp';
CREATE CAST (citext AS "timestamp") WITH FUNCTION "timestamp"(citext);
CREATE CAST ("timestamp" AS citext) WITH FUNCTION citext("timestamp");

CREATE FUNCTION citext(inet) RETURNS citext AS 'network_show'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION citext(inet) TO PUBLIC;
COMMENT ON FUNCTION citext(inet) IS 'show all parts of inet/cidr value';

CREATE FUNCTION cidr(citext) RETURNS cidr AS 'text_cidr'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION cidr(citext) TO PUBLIC;
COMMENT ON FUNCTION cidr(citext) IS 'citext to cidr';

CREATE FUNCTION like_escape(citext, citext) RETURNS citext AS 'like_escape'  LANGUAGE 'internal' IMMUTABLE STRICT;
GRANT EXECUTE ON FUNCTION like_escape(citext, citext) TO PUBLIC;
COMMENT ON FUNCTION like_escape(citext, citext) IS 'convert LIKE pattern to use backslash escapes';

COMMIT;
