<?php
// calpp_data_manipulation.inc
// functions to manipulate data in calpp database
require_once "$CLP_BASE/db_pgsql_lib.inc";
require_once "$CLP_BASE/ind_num2words.inc";

function get_datediff($date1, $date2){
    // returns array of date diff elements: d, m, y, days, months, years, weeks
    // returns 0 if invalid or empty dates are furnished
    if (empty($date1) || empty($date2)){
	return 0;
    } else {	
	list( $year1, $month1, $day1 ) = split( '[/.-]', $date1 );
	list( $year2, $month2, $day2 ) = split( '[/.-]', $date2 );
	$timestamp1=mktime(0,0,0,$month1, $day1, $year1);
	$timestamp2=mktime(0,0,0,$month2, $day2, $year2);
	$diff = ($timestamp1 > $timestamp2) ? ($timestamp1 - $timestamp2) : ($timestamp2 - $timestamp1);
	$diff_years= date("Y", $diff) - 1970;
	$diff_months=date("m", $diff) -1;
	$diff_days=date("d", $diff) - 1;

	$dg = "<h1>Timestamp1:$date1: $timestamp1 <br>Timestamp2: $date2:$timestamp2</h1>";
	$dg .=  "<table>";
	$dg .= "<tr><td>Date 1:<td>$day1-<td>$month1-<td>$year1";
	$dg .= "<tr><td>Date 2:<td>$day2-<td>$month2-<td>$year2";
	$dg .= "<tr><td>Difference:<td>$diff_days-<td>$diff_months-<td>$diff_years";
	$dg .= "</table>";
        $result[y]=$diff_years;
        $result[m]=$diff_months;
        $result[d]=$diff_days;
        $result[birth_date]="$day1-$month1-$year1";
        return $result;
        
    }
}

function get_record_info($field_name, $id){
// returns the record information in an array
    $fn_len = strlen($field_name) - 3;
    $table_name = substr($field_name, 0, $fn_len) . "s";
    $sql = "select * from $table_name where $field_name=$id";
    //$result = $sql;
    $result = Retn_Row($sql);
    $script_file = "/usr/local/httpd/htdocs/calpptechno/$table_name/" . $id . ".inc";
    $test_existence = file_exists($script_file);
    if ($test_existence==TRUE){
	 $result['script_file_exists']=true;
    } else {
	 $result['script_file_exists']=false;
    }
    $result['script_file'] = $script_file;  
    return $result;
}
    
function get_row_info($field_name, $id){
    // alias for get_record_info
    $result = get_record_info($field_name, $id);
    return $result;
}   
function get_contact_info($contact_id){
// returns the contact information in contacts table as an array along with manipulated data    
    $sql = "select * from contacts where contact_id=$contact_id";
    $contact = Retn_Row($sql);
    $contact[tin]= $contact[title] . ' ' . $contact[initials] . ' ' . $contact[name];
    $contact[tinq]= $contact[tin] . ' ' . $contact[qualification];
    if ($contact[pincode]!=''){
	$contact[dt_pin] = $contact[district] . " - " . $contact[pincode];
    } else {
        $contact[dt_pin] = $contact[district];
    }
    $date_today = date("Y-m-d");
    $ar_age = get_datediff($contact[birth_date], $date_today);
    $contact[y] = $ar_age[y];
    $contact[m] = $ar_age[m];
    $contact[d] = $ar_age[d];
    $contact[dn_st] = $contact[door_no] . ' ' . $contact[street];
    if ($contact[dn_st] != ''){
        $contact[dn_st] .= ", \r\n";
    }
    $contact[address]= $contact[dn_st];
    if ($contact[village] != ''){
        $contact[address] .= $contact[village] . ", \r\n";
    }
    if ($contact[taluk] != ''){
        $contact[address] .= $contact[taluk] . ", \r\n";
    }
    $contact[address] .= $contact[dt_pin] . "\r\n";
    $contact[address_br] = nl2br($contact[address]);
    
    return $contact;

}

function get_proc($proc_code){
    // returns procedure particulars based on proc_code
    $sql = "select * from procedures where procedure_code='$proc_code'";
    $result = Retn_Row($sql);  
    $script_file = "$CLP_BASE/procedures/" . $result[procedure_id] . ".inc";
    $test_existence = file_exists($script_file);
    if ($test_existence==TRUE){
	 $result['script_file_exists']=TRUE;
    } else {
	 $result['script_file_exists']=FALSE;
    }
    $result['script_file'] = $script_file;  
    return $result;
}

function reverse($str){
    $n = strlen($str);
    for ($i=0; $i < $n; $i++){
       $result = $str[$i] . $result;       
    }
    return $result;
}

function fmt_cur($cur, $round_to='0'){
    if ($round_to==1){
        $cur = round($cur);
        $sql = "select to_char($cur, '99G99G99G99G99G999')";
        $result = Retn_Result($sql);
        $result .= "/-";
    } else {
        $cur = sprintf ("%01.2f", $cur);
        $sql = "select to_char($cur, '99G99G99G99G99G999.99')";
        $result = Retn_Result($sql);
    }
    return $result;
}

function get_chit_type_info($chitgrouptype_id){
// returns array about chit group type
    $sql = "select * from chitgrouptypes where chitgrouptype_id=$chitgrouptype_id";
    $chit_type = Retn_Row($sql);
    $chit_type[subscription_c] = fmt_cur($chit_type[subscription], 1);
    $chit_type[subscription_w] = ind_num2words($chit_type[subscription_c]);
    $chit_type[chit_amount_c] = fmt_cur($chit_type[chit_amount], 1);
    $chit_type[chit_amount_w] = ind_num2words($chit_type[chit_amount_c]);
    return $chit_type;
}

function get_chit_group_info($chitgroup_code){
    // returns array about chit group
    $sql = "select * from chitgroups where chitgroup_code='$chitgroup_code'";
    $result = Retn_Row($sql);
    //echo "sql:$sql<br>Result: $result";
    return $result;
}

function write_file($file_name, $contents, $write_mode="w+"){
    // save the $contents to $file_name and return TRUE if successful
    global $debug;
    if ($write_mode != "w+"){
	 $write_mode = "a+";
    }
    $fp = fopen("$file_name", $write_mode);
    $result=fputs($fp, $contents);
    fclose($fp);
    if ($result){
	 $debug[] ="wrote $file_name";
	 $result = TRUE;
    } else {
	 $debug[] ="failed to write to $file_name";
         $result = FALSE;
    }
    return $result;
}

function read_file($file_name){
    // read and return contents of $file_name
    $fp=fopen("$file_name", "r");
    $fsize=filesize("$file_name");
    $content=fread($fp, $fsize);
    fclose($fp);
    return $content;
}

function create_directory($new_dir_name){
    // creates new directory $new_dir_name and returns TRUE if successful
    $testfileexists=is_dir("$new_dir_name");
    if ($testfileexists==0) {
	 $makenewdir=mkdir("$new_dir_name", 0700);
         if ($makenewdir==1){
	      $result = TRUE;
	 } else {
	      $result = FALSE;
	 }
    } else {
	 $result = FALSE;
    }
    return $result; 
}

?>





