/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "intnuminput.h"
#include "parameter.h"

using namespace WorKflow;

IntNumInput::IntNumInput(QWidget* parent, const char* name)
  : KIntNumInput(parent, name)
{
  connect(this, SIGNAL(valueChanged(int)), this, SLOT(slotChanged()));
}

IntNumInput::~IntNumInput()
{
}

QString IntNumInput::parameterId() const
{
  return WidgetInterface::parameterId();
}

Value IntNumInput::value()
{
  return Value::singleNumber(parameter()->typeId(), KIntNumInput::value());
}

void IntNumInput::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

void IntNumInput::setValue(const Value& value)
{
  KIntNumInput::setValue(value.asStringList().first().toInt());
}

void IntNumInput::slotChanged()
{
  if (!parameter())
    return;

  emit changed(value());
}

#include "intnuminput.moc"
