/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klistview.h>
#include <kpushbutton.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kdebug.h>

// Qt includes
#include <qgroupbox.h>
#include <qdir.h>

// WorKflow includes
#include "selectworkflowdialog.h"
#include "selectworkflowdialog_p.h"
#include "workflowlistitem.h"
#include "applicationdescription.h"
#include "applicationmanager.h"
#include "application.h"

using namespace WorKflow;

QString SelectWorkflowDialog::edit(QWidget* parent, const QString& appid)
{
  SelectWorkflowDialogPrivate dialog(parent, appid, true);
  if (dialog.exec())
    return dialog.selected();
  else
    return QString::null;
}

QString SelectWorkflowDialog::execute(QWidget* parent, const QString& appid)
{
  SelectWorkflowDialogPrivate dialog(parent, appid, false);
  if (dialog.exec())
    return dialog.selected();
  else
    return QString::null;
}

SelectWorkflowDialogPrivate::SelectWorkflowDialogPrivate(QWidget* parent, const QString& appid, bool edit)
  : SelectWorkflowDialogBase(parent)
{
  init(appid);

  if (edit)
    m_groupBox->setTitle(i18n("Select Workflow to Edit"));
  else
    m_groupBox->setTitle(i18n("Select Workflow to Execute"));
}

SelectWorkflowDialogPrivate::~SelectWorkflowDialogPrivate()
{
}

void SelectWorkflowDialogPrivate::init(const QString& appid)
{
//   ApplicationDescription* desc = ApplicationManager::find(appid);
//   if (desc) {
//     QString id = desc->id();

    KStandardDirs stdDirs;
    QStringList dirs = stdDirs.findDirs("data", "workflow/apps/" + appid);

    for (QStringList::ConstIterator i = dirs.begin(); i != dirs.end(); ++i) {
      QDir dir(*i, "*.workflow");

      QStringList files = dir.entryList();
      for (QStringList::ConstIterator j = files.begin(); j != files.end(); ++j) {
        new WorkflowListItem(m_listView, *i + '/' + *j);
      }
    }
//   }
}

void SelectWorkflowDialogPrivate::slotSelectionChanged()
{
  QListViewItem* item = m_listView->selectedItem();
  m_okButton->setEnabled(item != 0);
}

QString SelectWorkflowDialogPrivate::selected()
{
  WorkflowListItem* item = static_cast<WorkflowListItem*>(m_listView->selectedItem());

  if (item)
    return item->filename();

  return QString::null;
}

QString WorKflow::SelectWorkflowDialog::appDir()
{
  QString appid = mainAppId();
  KStandardDirs stdDirs;
  QStringList dirs = stdDirs.findDirs("data", "");
  QString maindir = dirs.first() + "workflow/apps/";
  QString appdir = maindir + appid + '/';
  stdDirs.makeDir(maindir);
  stdDirs.makeDir(appdir);
  kdDebug() << appdir << endl;
  return appdir;
}

QString WorKflow::SelectWorkflowDialog::mainAppId()
{
  Application* app = ApplicationManager::mainApplication();
  QString appid = "workflow";
  if (app)
    appid = app->id();
  return appid;
}

#include "selectworkflowdialog_p.moc"
