/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COMMANDWIDGET_H
#define COMMANDWIDGET_H

// Qt includes
#include <qwidget.h>

// forward declarations
class QFrame;
class QLineEdit;

namespace WorKflow
{
  class Command;
  class CommandCounter;
  class CloseWidget;
  class CommandPort;
  class CollapseWidget;
  class View;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class CommandWidget : public QWidget
  {
    Q_OBJECT

  public:
    CommandWidget(QWidget *parent, Command* cmd);
    ~CommandWidget();

    int row();
    bool isSelected();

    void collapse();
    void uncollapse();

  public slots:
    void setOrder(int row);
    void setSelected(bool selected);

  signals:
    void closed(Command*);
    void minimumSizeChanged();
    void selectionChanged(CommandWidget*);

  private slots:
    void slotPortChanged();
    void showMenu(QPoint pos);
    void rename();
    void remove();
    void moveUp();
    void moveDown();
    void toggleCollapse();

    void updateGUI();
    void updateToolTip();

  private:
    Command* m_command;
    CommandCounter* m_counter;
    CollapseWidget* m_collapse;
    CloseWidget* m_close;

    CommandPort* m_inPort;
    CommandPort* m_outPort;
    QLineEdit* m_title;
    QFrame* m_mainWidget;
    View* m_containerView;

    bool m_selected;
  };
}

#endif
