/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <klocale.h>
#include <kdebug.h>
#include <kaction.h>
#include <kstatusbar.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

// Qt includes
#include <qdockwindow.h>
#include <qsplitter.h>

// WorKflow includes
#include "librarymanager.h"
#include "librarydescription.h"

// designer includes
#include "mainwindow.h"
#include "librarywidget.h"
#include "iowidget.h"
#include "editwidget.h"
#include "librarydialog.h"

using namespace WorKflow;

MainWindow::MainWindow()
  : KMainWindow(0, "MainWindow"), m_library(0)
{
  setupActions();
  statusBar()->show();
  setupGUI();

//   connect(LibraryManager::self(), SIGNAL(allLibrariesLoaded()), this, SLOT(slotLibrariesLoaded()));

/*  if (!category.isEmpty()) {
    Category* cat = CommandManager::self()->findCategory(category);
    if (cat) {
      m_categoryCombo->
    }
  }*/

//   CommandDialog::newCommand(this);

  QSplitter* splitter = new QSplitter(QSplitter::Horizontal, this);

  m_libraryWidget = new LibraryWidget(splitter);
  m_libraryWidget->setEnabled(false);
  m_editWidget = new EditWidget(splitter);
  m_ioWidget = new IoWidget(splitter);
  m_ioWidget->setEnabled(false);

  splitter->setResizeMode(m_libraryWidget, QSplitter::KeepSize);
  splitter->setResizeMode(m_editWidget, QSplitter::Stretch);
  splitter->setResizeMode(m_ioWidget, QSplitter::KeepSize);

  setCentralWidget(splitter);

  connect(m_libraryWidget, SIGNAL(commandSelected(WorKflow::CommandDescription*)),
          m_editWidget, SLOT(setCommandDescription(WorKflow::CommandDescription*)));
  connect(m_libraryWidget, SIGNAL(commandSelected(WorKflow::CommandDescription*)),
          m_ioWidget, SLOT(setCommandDescription(WorKflow::CommandDescription*)));
}

MainWindow::~MainWindow()
{
  if (m_library)
    delete m_library;
}

void MainWindow::setupActions()
{
  KStdAction::openNew(this, SLOT(newLibrary()), actionCollection());
  KStdAction::open(this, SLOT(open()), actionCollection());
  KStdAction::save(this, SLOT(save()), actionCollection());
  KStdAction::saveAs(this, SLOT(saveAs()), actionCollection());
  KStdAction::quit(kapp, SLOT(quit()), actionCollection());

  m_loadLibraries = new KAction(i18n("Load installed libraries"), CTRL + Key_L,
                                     this, SLOT(loadLibraries()),
                                     actionCollection(), "load_libraries_action");

//   m_resultInspector = new KToggleAction(i18n("Result Inspector..."), "find", CTRL + Key_R,
//                                 this, SLOT(showResultInspector()),
//                                 actionCollection(), "result_inspector_action");
// 
//   m_execute = new KAction(i18n("Execute Command"), "run", CTRL + Key_X,
//                                 this, SLOT(executeCommand()),
//                                 actionCollection(), "execute_command_action");

//   updateActionState();
}

void MainWindow::newLibrary()
{
  LibraryDescription* desc = LibraryDialog::newLibrary(this);
  if (desc) {
    MainWindow* wnd = newWindow();

    wnd->setLibrary(desc);
  }
}

void MainWindow::open()
{
  KURL url = KFileDialog::getOpenURL(QString::null, "*.wflib", this, i18n("Open Location"));
  if (!url.isEmpty() && url.isLocalFile()) {
    MainWindow* wnd = newWindow();
    wnd->m_filename = url.path();

    wnd->setLibrary(new LibraryDescription(wnd->m_filename));
  }
}

void MainWindow::save()
{
  if (m_filename.isEmpty()) {
    saveAs();
    return;
  }

  QString xml = m_library->writeXML();
  QFile file(m_filename);
  if (!file.open(IO_WriteOnly)) {
    KMessageBox::sorry(this, i18n("Could not write file %1"), i18n("Save File"));
    return;
  }
  QTextStream stream(&file);
  stream << xml;
  file.close();
}

void MainWindow::saveAs()
{
  KURL url = KFileDialog::getSaveURL(QString::null, "*.wflib", this, i18n("Save Library"));
  if (!url.isEmpty() && url.isLocalFile()) {
    m_filename = url.path();
    save();
  }
}

void MainWindow::setLibrary(LibraryDescription* library)
{
  m_library = library;
  if (library) {
    m_libraryWidget->setLibrary(m_library);

    setCaption(m_library->name());
  }
}

MainWindow* MainWindow::newWindow()
{
  if (!m_library)
    return this;
  MainWindow* wnd = new MainWindow;
  wnd->show();
  return wnd;
}

void MainWindow::loadLibraries()
{
  LibraryManager::self()->loadAllLibraries();
}

#include "mainwindow.moc"
