/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef CONVERSION_H
#define CONVERSION_H

// Qt includes
#include <qregexp.h>

// WorKflow includes
#include "xmldescription.h"
#include "value.h"

// forward declarations
namespace WorKflow
{
  class LibraryDescription;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke <tkadauke@gmx.de>
   */
  class Conversion : public WorKflow::XMLDescription
  {
  public:
    enum Action {
      NoAction,
      GrepAction,
      ScriptAction,
      CustomAction
    };

    Conversion(LibraryDescription* parent);
    ~Conversion();

    Action action() const;

    QString sourceTypeId() const;
    QString destTypeId() const;

    QRegExp grepExpression() const;

    void setAction(Action action);
    void setSourceTypeId(const QString& source);
    void setDestTypeId(const QString& dest);
    void setGrepExpression(const QRegExp& expr);

    virtual Value convert(const Value& v);

    virtual void readXML(const QDomElement& e);
    virtual void writeXML(QDomDocument& doc, QDomElement& e);

  protected:
    /**
     * Registers this conversion with the TypeManager class.
     */
    void registerConversion();

    /**
     * Removes this conversion from the list of registered conversions in the
     * TypeManager class.
     */
    void unregisterConversion();

  private:
    LibraryDescription* m_parent;
    QString m_sourceTypeId;
    QString m_destTypeId;
    QRegExp m_grepExpr;
    Action m_action;
  };
}

#endif
