/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWAPPLICATIONFACTORY_H
#define WORKFLOWAPPLICATIONFACTORY_H

// Qt includes
#include <qstring.h>

// forward declarations
namespace WorKflow
{
  class Application;
  class ApplicationDescription;
}

namespace WorKflow
{
  /**
    @author Thomas Kadauke <tkadauke@gmx.de>
  */
  class ApplicationFactoryBase
  {
  public:
    ApplicationFactoryBase(const QString& id);
    virtual ~ApplicationFactoryBase();

    virtual Application* create(const QString& dcopName) = 0;

  protected:
    ApplicationDescription* m_description;
  };


  template<class App>
  class ApplicationFactory : public ApplicationFactoryBase
  {
  public:
    inline ApplicationFactory(const QString& id)
      : ApplicationFactoryBase(id) {}

    virtual Application* create(const QString& dcopName)
    {
      return new App(m_description, dcopName);
    }
  };
}

#endif
