/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kprocess.h>
#include <kurl.h>
#include <klocale.h>

// command includes
#include "convertimagecommand.h"
#include "convertimagewidget.h"

using namespace WorKflow;

ConvertImageCommand::ConvertImageCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  ConvertImageWidget* w = new ConvertImageWidget(this);
  setWidget(w);
}

ConvertImageCommand::~ConvertImageCommand()
{
}

void ConvertImageCommand::execute()
{
  // TODO: other parameters (exclude, etc)

  QStringList files = value("images").asStringList();
  QStringList res;

  QString destExtension = value("desttype").enumKey();

  int count = files.count();
  int num = 1;
  for (QStringList::ConstIterator i = files.begin(); i != files.end(); ++i, ++num) {
    KProcess proc;
    proc << "convert";
    KURL url(*i);

    if (url.isLocalFile()) {
      QString path = url.path();
      int index = path.findRev('.');
      QString baseName = path.left(index);
      QString ext = path.mid(index + 1);
      // TODO: check if extension is supported
      QString convertedName = (baseName + '.' + destExtension);

      emit progress(double(num) / double(count), i18n("Converting image %1 to %2").arg(*i).arg(convertedName));

      proc << path << convertedName;
      proc.start();

      waitFor(&proc, SIGNAL(processExited(KProcess*)));

      res.append(convertedName);
    } else {
      // TODO: warn user? or download and upload afterwards?
    }
  }

  setResult("converted", Value::stringList("org.kde.public.imagefile", res));

  Command::execute();
}
