/***************************************************************************
                          ksteak.cpp  -  description
                             -------------------
    begin                : Thu Nov 14 09:16:56 CEST 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksteak.h"
#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qcursor.h>
#include <qregexp.h>
#include <klocale.h>

/**************************************************
 * constructor																		*
 **************************************************/
Ksteak::Ksteak(QWidget *parent, const char *name) : QWidget(parent, name)
{
  English = FALSE;
  German = FALSE;
  Context = FALSE;
  Sensitive = FALSE;
  SearchAnd = FALSE;
  SearchOr = FALSE;
  docked = FALSE;

  ViewSteak = new QMultiLineEdit(this,"ViewSteak");
  ViewSteak->setReadOnly(true);
 /* ViewSteak = new QListView(this);
    ViewSteak->addColumn("Deutsch");
    ViewSteak->addColumn("English");*/
  
  LabelSearch = new QLabel(i18n("Search"), this);
  LineSearch = new KComboBox(TRUE, this);
  connect(LineSearch, SIGNAL(activated(int)), this, SLOT(getTranslation(int)));
}

/**************************************************
 * destructor                                     *
 **************************************************/
Ksteak::~Ksteak()
{
}

/**************************************************
 * steak aufrufen und output anzeigen							*
 **************************************************/
void Ksteak::getTranslation(int index)
{
  FILE *fp;
  QString command;
  QString sline;//(1024);	
  char line[1024];

  ViewSteak->clear();	
  KApplication::setOverrideCursor(waitCursor);
	
  //Befehl zusammensetzen
  command="/usr/local/bin/steak -nowait";
  if (English & German) command.append(" -de");
  else if (German) command.append(" -d");
  else if (English) command.append(" -e");
  if ((!Context) || (docked)) command.append(" -k");
  if (Sensitive) command.append(" -noignor");
  if (SearchAnd) command.append(" -and");
  if (SearchOr) command.append(" -or");
  command.append(" ");

  //Eingabe an Befehl haengen
  if (!docked)
  {
    if (index < 0) command.append(LineSearch->currentText());
    else command.append(LineSearch->text(index));
  }
  //ausfuehren
  if ((fp = popen(command, "r")) == NULL)
    {
      fprintf(stderr, "popen error");
      exit(1);
    }
  while ((fgets(line, 1024, fp)) != NULL)
    {
      sline = line;	
      sline=sline.stripWhiteSpace();
      //haessliche Zeilen rausfiltern
      //sline.replace( QRegExp("[<>]"), "" );
      if (!sline.contains("---", TRUE)) ViewSteak->insertLine(sline);
      if (sline.contains("--- Jetzt die Kontext", TRUE)) ViewSteak->insertLine(i18n("------- Context -------"));
    }
  if (ferror(fp)) printf("fgets error");
  pclose(fp);
  KApplication::restoreOverrideCursor();
}

/**********************************************
 * auf Aenderung der Fenstergroesse reagieren *
 **********************************************/
void Ksteak::resizeEvent(QResizeEvent *)
{
  LabelSearch->setGeometry(10,10,60,30);
  LineSearch->setGeometry(80,10,width()-90,30);
  ViewSteak->setGeometry(5,50,width()-10,height()-60);
}
