/***************************************************************************
                          kfilereplaceview.h  -  description                              
                             -------------------                                         
    begin                : ven jun 11 17:07:02 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILEREPLACEVIEW_H 
#define KFILEREPLACEVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktabctl.h>


#include <qwidget.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qstrlist.h>
#include <qfiledialog.h>

#include "kfilereplacedoc.h"


/**
  * This class provides an incomplete base for your application view. 
   */

class KFileReplaceView : public QWidget
{
	Q_OBJECT

 	public:
		/** Constructor for the main view */
  	KFileReplaceView(KApplication* a=0,KFileReplaceDoc* doc=0,QWidget *parent = 0);
  /**  */
  void EnableWidgets(bool bState);
  	/** Destructor for the main view */
  	~KFileReplaceView();

	public:
		QComboBox* GetComboDir() {return m_comboDir;}
		QComboBox* GetComboFilter() {return m_comboFilter;}
		QComboBox* GetComboSearch() {return m_comboSearch;}
		QComboBox* GetComboReplace() {return m_comboReplace;}
		QCheckBox* GetCheckRecursiveFolders() {return m_checkRecursive;}
		QCheckBox* GetCheckCaseSensitive() {return m_checkCaseSensitive;}
		QCheckBox* GetCheckBakup() {return m_checkBakup;}
		QListView* GetListView() {return m_List;}
		QListView* GetTextList() {return m_TextList;}
		QCheckBox* GetCheckDateOption() {return m_checkDateOption;}
		QCheckBox* GetCheckDateMin() {return m_checkDateMin;}
		QCheckBox* GetCheckDateMax() {return m_checkDateMax;}
		QComboBox* GetComboDateRW() {return m_comboDateRW;}
		QLineEdit* GetEditDateMax() {return m_editDateMax;}
		QLineEdit* GetEditDateMin() {return m_editDateMin;}

		void GetMaxFilesSize(bool *bChecked, uint *nMaxSize);
		void GetMinFilesSize(bool *bChecked, uint *nMinSize);
		void ResizeWidgets( QResizeEvent * );	

	private:	
		KTabCtl *m_tabctl;
		QWidget *m_Page;
		KApplication *m_app;

		QComboBox* m_comboDir;
		QComboBox* m_comboFilter;
		QComboBox* m_comboSearch;
		QComboBox* m_comboReplace;

		QLabel* m_labelDir;
		QLabel* m_labelFiles;
		QLabel* m_labelSearchfor;
		QLabel* m_labelReplaceby;
		QPushButton* m_btnBrowse;
		QPushButton* m_btnAdd;
		QPushButton* m_btnRemove;
		QPushButton* m_btnClear;
		QListView* m_List;
		QListView* m_TextList;

		QCheckBox *m_checkRecursive;
		QCheckBox *m_checkCaseSensitive;
		QCheckBox *m_checkBakup;

		QCheckBox *m_checkSizeMin;
		QCheckBox *m_checkSizeMax;
		QLineEdit *m_editSizeMin;
		QLineEdit *m_editSizeMax;

		QLabel *m_labelKbMin;
		QLabel *m_labelKbMax;

		QCheckBox *m_checkDateOption;
		QCheckBox *m_checkDateMax;
		QCheckBox *m_checkDateMin;
		QComboBox *m_comboDateRW;
		QLineEdit *m_editDateMax;
		QLineEdit *m_editDateMin;
		QLabel *m_labelDate;

  public slots:
    void slotTabSelection(int pagenumber);
		void slotBrowse();
		void slotAdd();
		void slotRemove();
		void slotClear();
		void slotSizeMinClicked();
		void slotSizeMaxClicked();
		void slotDateOptionClicked();
		void slotDateMinClicked();
		void slotDateMaxClicked();


};

#endif // KFILEREPLACEVIEW_H 









































